/**    IAP demo : demo code for internal Flash memory access library
 *
 *        The internal Flash memory access is described in the LPC1768 and LPC11U24 usermanual.
 *            http://www.nxp.com/documents/user_manual/UM10360.pdf
 *            http://www.nxp.com/documents/user_manual/UM10462.pdf
 *
 *               LPC1768 --
 *                    Chapter  2: "LPC17xx Memory map"
 *                    Chapter 32: "LPC17xx Flash memory interface and programming"
 *                    refering Rev. 01 - 4 January 2010
 *
 *               LPC11U24 --
 *                    Chapter  2: "LPC11Uxx Memory mapping"
 *                    Chapter 20: "LPC11Uxx Flash programming firmware"
 *                    refering Rev. 03 - 16 July 2012
 *
 *  This main.cpp demonstrates how the flash can be erased and wrote.
 *
 *  This program tries to...
 *    0. read device ID and serial#

 *
 *        Released under the MIT License: http://mbed.org/license/mit
 */

#include    "mbed.h"
#include    "IAP.h"

#define     MEM_SIZE        256

#if defined(TARGET_LPC176X)
#define     TARGET_SECTOR    29     //  use sector 29 as target sector if it is on LPC1768
#elif defined(TARGET_LPC11UXX) || defined(TARGET_LPC11XX)
#define     TARGET_SECTOR    7      //  use sector  7 as target sector if it is on LPC11U24
#define     TARGET_EEPROM_ADDRESS   64
#define     TARGET_EEPROM_ADDRESS   64
#elif defined(TARGET_LPC81X) || defined(TARGET_LPC82X)
#define     TARGET_SECTOR    15      //  use sector  15 as target sector if it is on LPC812
#endif




void showDeviceInfo()
{
    void    memdump( char *p, int n );
    int     isprint( int c );
    IAP     iap;
    int     *serial_number;
    printf( "\r\n\r\n=== IAP: Flash memory writing test ===\r\n" );
    printf( "  device-ID = 0x%08X\r\n", iap.read_ID() );

    serial_number = iap.read_serial();

    printf( "  serial# =" );
    for ( int i = 0; i < 4; i++ )
        printf( " %08X", *(serial_number + i) );
    printf( "\r\n" );
    printf( "  CPU running %dkHz\r\n", SystemCoreClock / 1000 );
    printf( "  user reserved flash area: start_address=0x%08X, size=%d bytes\r\n", iap.reserved_flash_area_start(), iap.reserved_flash_area_size() );
    printf( "  read_BootVer=0x%08X\r\r\n", iap.read_BootVer() );


}



