#include "mbed.h"

PwmOut mypwm(PB_10);
DigitalOut led1(LED1);//LED1 = D13 = PA_5 (LED on Nucleo board)
Ticker timer1;
Ticker timer2;

int a;
int b;
int c;
float pwm_duty ;
double angle ;

void init_IO(void)
{
    a = 0;    
    b = 0;
    c = 0;
    led1 = 0;
    
}


void init_servo(void)
{
    angle = 0;
    pwm_duty = 0.079;
    mypwm.period_ms(20);
    mypwm.write(pwm_duty);
}


void timer1_interrupt(void)
{
    a ++ ;
    if (a == 500)led1 = 1;
                
    else if (a == 1000)
            {
                led1 = 0;                      
                a = 0;
                b = b+1;
            }
}


void init_TIMER(void)
{
    timer1.attach_us(&timer1_interrupt, 1000.0);//1ms interrupt period (1 KHz)
}






void run_servo(void)
{
    angle = angle + c * 0.015;
    pwm_duty = 0.079 +(0.084/180)*angle; 
    mypwm.write(pwm_duty);
    c++;
    if (c >6000) 
    {
        timer2.detach(); 
    }
}

void run_servo_counter(void)
{
    timer2.attach_us(&run_servo, 1000.0);//1ms interrupt period (1 KHz)
}

int main() 
{
    init_IO();
    init_servo();
    init_TIMER();
    
    while(1)
    {    
        
        if (b >= 3)
            {
                run_servo_counter();
            }
        
        else if(b > 10)
            {
                timer1.detach();
                timer2.detach();
                wait(1);
                init_IO();
                init_servo();
                wait(3);
                init_TIMER()
            
            }
    }
    
}

