#include "mbed.h"

Serial bt(D10,D2);
//Serial pc(D1,D0);
PwmOut mypwm(A0);

float pwm_duty = 0.079;
double angle = 0;



void setPWM(char c) 
{
    switch( c ) 
    {
        case 'i': angle = 0;
        case 'a': angle = 30;
        case 'b': angle = 60;
        case 'c': angle = 90;
       
    }
     
}

void init_servo(void)
{
    angle = 0;
    pwm_duty = 0.079;
    mypwm.period_ms(20);
    mypwm.write(pwm_duty);
}

int main() 
{
    bt.baud(115200);
    //pc.baud(57600);
    init_servo();
    
    while(1)
    {
        
        int input = bt.getc();
        setPWM( input );
        
        bt.printf("%c",input); 
        wait(1);
        
        pwm_duty = 0.079 +(0.084/180)*angle;

        mypwm.period_ms(20);
        mypwm.write(pwm_duty);
    }

}
