#ifndef WADABED_H
#define WADABED_H

// Includes
#include "mbed.h"
#include <stdlib.h>
#include <string.h>

// pin define
DigitalOut STATUS_LED(LED1);
DigitalOut Naoto_LED(LED2);
DigitalOut ESP8266_LED(LED3);
DigitalOut IM920_LED(LED4);
DigitalOut OutSide_LED(p21);
DigitalIn BUSY(p26); // IM920 BUSY port

// Serial define
Serial USB(USBTX, USBRX); // USB port
Serial Naoto(p9, p10); // mbed port
Serial ESP8266(p13, p14); // ESP8266 port
Serial IM920(p28, p27); // IM920 port

// Timer define
Ticker LED;

// Variable define
char rcvBUFF_Naoto[40];
char rcvBUFF_ESP8266[20];
char rcvBUFF_IM920[20];
char outputDATA[20];
int deadCount = 0;

void printValue(int *ValueBuff) {
    /*
    int A2, X, Y, Bs, Bt; 
    A2 = (ValueBuff[0] >> 6) & 1;
    X = (ValueBuff[0] >> 3) & 7;
    Y = ValueBuff[0] & 7;
    Bs = (ValueBuff[1] >> 4) & 7;
    Bt = ValueBuff[1] & 15;
    USB.printf("A2=%d, X=%d, Y=%d, Bs=%d, Bt=%d\r\n", A2, X, Y, Bs, Bt);
    USB.printf("%2X, %2X\r\n", ValueBuff[0], ValueBuff[1]);
    */
    Naoto.putc(ValueBuff[0]);
    Naoto.putc(ValueBuff[1]);
    Naoto.putc(0x0A);  
}

void ConvrecvDATA(char *buff, int device = 0) {
    int sendNaotoBuff[2];
    char s1[2], s2[2];//, s3[2], s4[2];
    if (device == 1) {
        strncpy(s1, buff+5, 2);
        strncpy(s2, buff+7, 2);
    }
    else {
        strncpy(s1, buff+11, 2);
        strncpy(s2, buff+14, 2);
    }
    sendNaotoBuff[0] = strtoul(s1, (char **) NULL, 16);
    sendNaotoBuff[1] = strtoul(s2, (char **) NULL, 16);
    if (sendNaotoBuff[0] != 0 || sendNaotoBuff[1] != 0){
        printValue(sendNaotoBuff);
    }
}

inline void Naoto_RX() {
    Naoto_LED = 1;
    char rcvDATA;
    static int rcvCOUNT = 0;
    rcvDATA = Naoto.getc();
    rcvBUFF_Naoto[rcvCOUNT] = rcvDATA;
    rcvCOUNT++;
    if (rcvDATA == 0x0A) {
        rcvCOUNT = 0;
        Naoto_LED = 0;
    }
    else if (rcvCOUNT >= 40) {
        rcvCOUNT = 0;
        memset(rcvBUFF_Naoto, '\0', 40);
    }
}

inline void ESP8266_RX() {
    ESP8266_LED = 1;
    char rcvDATA;
    static int rcvCOUNT = 0;
    rcvDATA = ESP8266.getc();
    rcvBUFF_ESP8266[rcvCOUNT] = rcvDATA;
    rcvCOUNT++;
    if (rcvDATA == 0x0A) {
        ConvrecvDATA(rcvBUFF_ESP8266, 1);
        ESP8266_LED = 0;
        rcvCOUNT = 0;
        deadCount++;
        memset(rcvBUFF_ESP8266, '\0', 20);
    }
    else if (rcvCOUNT >= 20) {
        rcvCOUNT = 0;
        memset(rcvBUFF_ESP8266, '\0', 20);
    }
}

inline void IM920_RX() {
    IM920_LED = 1;
    char rcvDATA;
    static int rcvCOUNT = 0;
    rcvDATA = IM920.getc();
    rcvBUFF_IM920[rcvCOUNT] = rcvDATA;
    rcvCOUNT++;
    if (rcvDATA == 0x0A) {
        ConvrecvDATA(rcvBUFF_IM920, 0);
        IM920_LED = 0;
        rcvCOUNT = 0;
        deadCount++;
        memset(rcvBUFF_IM920, '\0', 20);
    }
    else if (rcvCOUNT >= 20) {
        rcvCOUNT = 0;
        memset(rcvBUFF_IM920, '\0', 20);
    }
}

void deadChecker() {
    if (deadCount > 10) {
        STATUS_LED = 1;
        OutSide_LED = 1;
    }
    else if (deadCount > 2) {
        STATUS_LED = !STATUS_LED;
        OutSide_LED = !OutSide_LED;
    }
    else {
        STATUS_LED = 0;
        OutSide_LED = 0;
    }
    deadCount = 0;
}

void initializeCom() {
    USB.baud(115200);
    Naoto.baud(115200);
    Naoto.format(8, Serial::Even, 1);
    Naoto.attach(Naoto_RX, Serial::RxIrq);
    ESP8266.baud(115200);
    ESP8266.format(8, Serial::Even, 1);
    ESP8266.attach(ESP8266_RX, Serial::RxIrq);
    IM920.baud(9600);
    IM920.format(8, Serial::None, 1);
    IM920.attach(IM920_RX, Serial::RxIrq);
    LED.attach(deadChecker, 0.5);
}

#endif