/**
 * This define list is included main.cpp.
 * Defined some parameters.
 */

#ifndef PARAMETERS_H
#define PARAMETERS_H

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

/**
 * PID parameters.
 */

/***Move PID controller***/
#define MOVE_R_INPUT_LIMIT_BOTTOM -100.0
#define MOVE_R_INPUT_LIMIT_TOP 100.0
#define MOVE_R_OUTPUT_LIMIT_BOTTOM -1.0
#define MOVE_R_OUTPUT_LIMIT_TOP 1.0
#define MOVE_R_BIAS 0.0
#define MOVE_R_Kc 0.1
#define MOVE_R_TAUi 0.005
//#define MOVE_R_TAUi 0.01
#define MOVE_R_TAUd 0.01

#define MOVE_L_INPUT_LIMIT_BOTTOM -100.0
#define MOVE_L_INPUT_LIMIT_TOP 100.0
#define MOVE_L_OUTPUT_LIMIT_BOTTOM -1.0
#define MOVE_L_OUTPUT_LIMIT_TOP 1.0
#define MOVE_L_BIAS 0.0
#define MOVE_L_Kc 0.1
#define MOVE_L_TAUi 0.005
//#define MOVE_L_TAUi 0.01
#define MOVE_L_TAUd 0.001

/***Swing speed PID controller***/
#define SWING_INPUT_LIMIT_BOTTOM -1000000.0
#define SWING_INPUT_LIMIT_TOP 1000000.0
#define SWING_OUTPUT_LIMIT_BOTTOM 0.0
#define SWING_OUTPUT_LIMIT_TOP 1.0
#define SWING_BIAS 0.0
#define SWING_Kc 1000.0
#define SWING_TAUi 0.01 //tau_i
#define SWING_TAUd 0.0  //tau_d

/**
 * Motor Parameters.
 */

/***Move motor period us.***/
#define MOVE_R_PERIOD_US 125
#define MOVE_L_PERIOD_US 125
#define SWING_PERIOD_US 125

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

#endif /*Parameters.h*/