/**
 * This define list is included main.cpp.
 * Defined pins for each function.
 */

#ifndef PIN_DEFINE_H
#define PIN_DEFINE_H

/////////////////////////////////////////////////////////////////////////

/**
 * Defines
 */

/***Emergency stop.***/
#define Emergency_Stop p8
DigitalOut Emergency_stop(Emergency_Stop);

/****The pin is to communicate with RS_485****/
#define RS485_TX p9
#define RS485_RX p10

/****The pin is to communicate with SBDBT****/
#define SBDBT_TX p28
#define SBDBT_RX p27

/****The pin is to conect to encoder which sense migration length****/
#define ENCOD_MOVE_R_A p25
#define ENCOD_MOVE_R_B p26
QEI Move_r_sense(ENCOD_MOVE_R_A, ENCOD_MOVE_R_B, NC, 400, QEI::X4_ENCODING);

/****The pin is to conect to encoder which sense migration length****/
#define ENCOD_MOVE_L_A p15
#define ENCOD_MOVE_L_B p16
QEI Move_l_sense(ENCOD_MOVE_L_A, ENCOD_MOVE_L_B, NC, 400, QEI::X4_ENCODING);

/****The pin is to conect to motor which to move.****/
#define MOTOR_MOVE_R_CW p13
#define MOTOR_MOVE_R_CCW p14
#define MOTOR_MOVE_R_PWM p22
DigitalOut Move_r_Motor_CW(MOTOR_MOVE_R_CW);
DigitalOut Move_r_Motor_CCW(MOTOR_MOVE_R_CCW);
PwmOut Move_r_Motor_PWM(MOTOR_MOVE_R_PWM);

/****The pin is to conect to motor which to move.****/
#define MOTOR_MOVE_L_CW p11
#define MOTOR_MOVE_L_CCW p12
#define MOTOR_MOVE_L_PWM p21
DigitalOut Move_l_Motor_CW(MOTOR_MOVE_L_CW);
DigitalOut Move_l_Motor_CCW(MOTOR_MOVE_L_CCW);
PwmOut Move_l_Motor_PWM(MOTOR_MOVE_L_PWM);

/***The pin is to conect to encoder motor.***/
#define ENCOD_SWING_A p5
#define ENCOD_SWING_B p6
#define ENCOD_SWING_Z p7
QEI Swing_speed_sense(ENCOD_SWING_A, ENCOD_SWING_B, ENCOD_SWING_Z, 360, QEI::X4_ENCODING);

/***The pin is to conect to swing motor.***/
#define MOTOR_SWING_PWM p23
PwmOut Motor_swing_pwm(MOTOR_SWING_PWM);

/////////////////////////////////////////////////////////////////////////

#endif /*PinDefine.h*/