#ifndef MACHINE_STATE_H
#define MACHINE_STATE_H

/**
 * Includes
 */
#include "mbed.h"
#include "QEI.h"

/**
 * Defines
 */
#define PI 3.14159265359

class MachineState {
    
public:    
    MachineState( double wheelRadius, double halfTread, double pulsePerRev,
           PinName rightChannelA, PinName rightChannelB, PinName leftChannelB, PinName leftChannelA, double PERIOD,
           double originY = 0.0, double originY = 0.0, double originSita = 0.0 );
    void reset(void);
    double getX(void);
    double getY(void);
    double getSita(void);
    double getVelocity(void);
    void mesureState(void);
    
private:
    
    QEI EncoderRight;
    QEI EncoderLeft;
    
    double PulsesRight_;
    double PulsesLeft_;
    double PrefPulsesRight_;
    double PrefPulsesLeft_;
    double dsita_;
    double dx_;
    double dy_;
    double dlr_;
    double dll_;
    double vr_;
    double vl_;
    double halfTread_;
    double PERIOD_;
    double pulsePerRev_;
    double wheelRadius_;
    volatile double x_;
    volatile double y_;
    volatile double sita_;
    volatile double velocity_;
};


#endif