/**
 * Includes
 */
#include "MachineState.h"

MachineState::MachineState( double wheelRadius, double halfTread, double pulsePerRev,
                            PinName rightChannelA, PinName rightChannelB, PinName leftChannelB, PinName leftChannelA, double PERIOD,
                            double originX , double originY , double originSita ) : EncoderRight( rightChannelA, rightChannelB, NC, pulsePerRev, QEI::X4_ENCODING ),
                                                                                    EncoderLeft ( leftChannelA,  leftChannelB,  NC, pulsePerRev, QEI::X4_ENCODING ) {
    PERIOD_          =  PERIOD;
    halfTread_       =  halfTread;
    pulsePerRev_     =  pulsePerRev;
    x_               =  originX;
    y_               =  originY;
    sita_            =  originSita;
    wheelRadius_     =  wheelRadius;
    PrefPulsesRight_ =  0.0;
    PrefPulsesLeft_  =  0.0;
}

void MachineState::reset(void){
    EncoderRight.reset();
    EncoderLeft.reset();
    x_    = 0.0;
    y_    = 0.0;
    sita_ = 0.0;
}

double MachineState::getX(void){
    return x_;
}

double MachineState::getY(void){
    return y_;
}

double MachineState::getSita(void){
    return sita_;
}

double MachineState::getVelocity(void){
    return velocity_;
}

void MachineState::mesureState(void){
    PulsesRight_     =  (double)EncoderRight.getPulses();
    PulsesLeft_      =  (double)EncoderLeft.getPulses();
    dlr_             =  2.0 * PI * wheelRadius_ * ( ( PulsesRight_ - PrefPulsesRight_ ) / (double)pulsePerRev_ );
    dll_             =  2.0 * PI * wheelRadius_ * ( ( PulsesLeft_  - PrefPulsesLeft_  ) / (double)pulsePerRev_ );
    PrefPulsesRight_ =  PulsesRight_;
    PrefPulsesLeft_  =  PulsesLeft_;
    vr_              =  dlr_ / PERIOD_;
    vl_              =  dll_ / PERIOD_;
    velocity_        =  ( vr_ + vl_ ) / 2.0;
    dsita_           =  ( dlr_ - dll_) / ( 2.0 * halfTread_ );
    dx_              =  ( ( dlr_ + dll_ ) / 2.0 ) * cos( sita_ + dsita_ / 2.0 );
    dy_              =  ( ( dlr_ + dll_ ) / 2.0 ) * sin( sita_ + dsita_ / 2.0 );
    sita_           +=  dsita_;
    x_              +=  dx_;
    y_              +=  dy_;
}