/**
 * This define list is included main.cpp.
 * Defined pins for each function.
 */

#ifndef PIN_DEFINE_BLUE_H
#define PIN_DEFINE_BLUE_H

/////////////////////////////////////////////////////////////////////////

/**
 * Defines
 */

/****The pin is to conect to encoder which sense migration length****/
#ifdef BLUE
#define ENCOD_MOVE_R_A      p6
#define ENCOD_MOVE_R_B      p5
#else
#define ENCOD_MOVE_R_A      p8
#define ENCOD_MOVE_R_B      p7
#endif
QEI Move_r_sense(ENCOD_MOVE_R_A, ENCOD_MOVE_R_B, NC, 400, QEI::X4_ENCODING);

/****The pin is to conect to encoder which sense migration length****/
#ifdef BLUE
#define ENCOD_MOVE_L_A      p7
#define ENCOD_MOVE_L_B      p8
#else
#define ENCOD_MOVE_L_A      p5
#define ENCOD_MOVE_L_B      p6
#endif
QEI Move_l_sense(ENCOD_MOVE_L_A, ENCOD_MOVE_L_B, NC, 400, QEI::X4_ENCODING);

/****The pin is to conect to motor which to move.****/
#ifdef BLUE
#define MOTOR_MOVE_R_CW     p17
#define MOTOR_MOVE_R_CCW    p18
#define MOTOR_MOVE_R_PWM    p22
#else
#define MOTOR_MOVE_R_CW     p20
#define MOTOR_MOVE_R_CCW    p19
#define MOTOR_MOVE_R_PWM    p23
#endif
DigitalOut Move_r_Motor_CW(MOTOR_MOVE_R_CW);
DigitalOut Move_r_Motor_CCW(MOTOR_MOVE_R_CCW);
PwmOut Move_r_Motor_PWM(MOTOR_MOVE_R_PWM);

/****The pin is to conect to motor which to move.****/
#ifdef BLUE
#define MOTOR_MOVE_L_CW     p19
#define MOTOR_MOVE_L_CCW    p20
#define MOTOR_MOVE_L_PWM    p23
#else
#define MOTOR_MOVE_L_CW     p18
#define MOTOR_MOVE_L_CCW    p17
#define MOTOR_MOVE_L_PWM    p22
#endif
DigitalOut Move_l_Motor_CW(MOTOR_MOVE_L_CW);
DigitalOut Move_l_Motor_CCW(MOTOR_MOVE_L_CCW);
PwmOut Move_l_Motor_PWM(MOTOR_MOVE_L_PWM);

/***The pin is to conect to swing motor and interrupter.***/
#define MOTOR_SWING_PWM     p21
PwmOut Motor_swing(MOTOR_SWING_PWM);
#define ENCOD_SWING_A       p11
#define ENCOD_SWING_B       p10
#define ENCOD_SWING_Z       p9
QEI SwingSens(ENCOD_SWING_A, ENCOD_SWING_B, ENCOD_SWING_Z, 360, QEI::X4_ENCODING);

/***indicator***/
DigitalOut Indicator1(LED1);
DigitalOut Indicator2(LED2);
DigitalOut Indicator3(LED3);
DigitalOut Indicator4(LED4);
DigitalOut IndicatorAuto(p16);
DigitalOut IndicatorBLUE(p25);
DigitalOut IndicatorRED(p24);
/////////////////////////////////////////////////////////////////////////

#endif /*PinDefine.h*/