#ifndef COMMUNICATE_H
#define COMMUNICATE_H

/***RS485 Communication.***/
#define RS485_TX p13
#define RS485_RX p14
Serial RS485(RS485_TX, RS485_RX);
#define EnablePin p12
DigitalOut Enable(EnablePin);
#define myaddress 8

char rcvBUFF[40];

inline void initializeRS485(){
    RS485.format(8,Serial::Even);
}

inline void sendData(int address, unsigned int data8) {
    unsigned int data;
    if (data8 <= 15) {
        data = 128 | (address << 4) | (data8 & 15);
        RS485.putc(data);
    }
    else if (data8 <= 255 && data8 >= 16) {
        data = (address << 4) | (data8 >> 4);
        RS485.putc(data);
        wait(0.000001);
        data = 128 | (address << 4) | (data8 & 15);
        RS485.putc(data);
    }
}

/***mbed Serial***/
#define MBED_TX p28
#define MBED_RX p27
Serial MbedSerial(MBED_TX,MBED_RX);
unsigned int b=0;
short modeflag=1;

inline void readValue(char *ValueBuff) {
    modeflag = (ValueBuff[0] >> 4) & 1;
    b = ValueBuff[0] & 15;
}

inline void getMbed() {
    char rcvDATA;
    static int rcvCOUNT = 0;
    rcvDATA = MbedSerial.getc();
    rcvBUFF[rcvCOUNT] = rcvDATA;
    rcvCOUNT++;
    if (rcvDATA == 0x0A) {
        readValue(rcvBUFF);
        rcvCOUNT = 0;
        memset(rcvBUFF, '\0', 40);
    }
    else if (rcvCOUNT >= 40) {
        rcvCOUNT = 0;
        memset(rcvBUFF, '\0', 40);
    }
}

inline void initializeMbedSerial(){
    MbedSerial.baud(115200);
    MbedSerial.format(8,Serial::Even);
    MbedSerial.attach(getMbed,Serial::RxIrq);
}
#endif