#ifndef SWING_H
#define SWING_H

/***Swing.***/
PID contSwing(5.917 ,30.0 ,0.0 ,RATE);
//PID contSwing(6.0 ,100.0 ,0.0 ,RATE);
Ticker interruptSwingSpeed;

int resetSwingSpeed = 0;

inline void countSwingSpeed() {
    static double i = 0.0;
    if (resetSwingSpeed == 1) {
        i = 0.0;
        resetSwingSpeed = 0;
    }
    if (i <= swingspeed) {
        i+=swingspeed/10.0;
        targSwingRadVelocity=i;
    }
    else {
        interruptSwingSpeed.detach();
    }
}


inline void initializeSwing() {
    Motor_swing.period_us(SWING_PERIOD);
    //controller set
    contSwing.setInputLimits(0.0, 50.0);
    contSwing.setOutputLimits(0.0, 1.0);
    contSwing.setBias(0.0);
    contSwing.setMode(AUTO_MODE);
}

double swingSita=0.0;
double Rad=0.0;
inline void mesureSwing() {
    PulsesSwing       = ( double )SwingSens.getPulses();
    swingRadVelocity  = (((PulsesSwing - PrefPulsesSwing) / 1445.0) * 2.0 * PI) / RATE;
    Rad = (PulsesSwing / 1445.0) * 2.0 * PI;
    if(Rad>2*PI) Rad-=2*Rad;
    PrefPulsesSwing   = PulsesSwing;
}

float cont=0.0;
inline void swingFollowing(){
    contSwing.setSetPoint(( float )targSwingRadVelocity);
    contSwing.setProcessValue(( float )swingRadVelocity);
    cont = contSwing.compute();
    Motor_swing = cont;
}

#endif /*Swing.h*/