/**
 * This define list is included main.cpp.
 * Defined pins for each function.
 */

#ifndef PIN_DEFINE_RED_H
#define PIN_DEFINE_RED_H

/////////////////////////////////////////////////////////////////////////

/**
 * Defines
 */

/****The pin is to conect to encoder which sense migration length****/
#define ENCOD_MOVE_R_A      p30
#define ENCOD_MOVE_R_B      p29
QEI Move_r_sense(ENCOD_MOVE_R_A, ENCOD_MOVE_R_B, NC, 400, QEI::X4_ENCODING);

/****The pin is to conect to encoder which sense migration length****/
#define ENCOD_MOVE_L_A      p25
#define ENCOD_MOVE_L_B      p26
QEI Move_l_sense(ENCOD_MOVE_L_A, ENCOD_MOVE_L_B, NC, 400, QEI::X4_ENCODING);

/****The pin is to conect to motor which to move.****/
#define MOTOR_MOVE_R_CW     p19
#define MOTOR_MOVE_R_CCW    p20
#define MOTOR_MOVE_R_PWM    p23
DigitalOut Move_r_Motor_CW(MOTOR_MOVE_R_CW);
DigitalOut Move_r_Motor_CCW(MOTOR_MOVE_R_CCW);
PwmOut Move_r_Motor_PWM(MOTOR_MOVE_R_PWM);

/****The pin is to conect to motor which to move.****/
#define MOTOR_MOVE_L_CW     p21
#define MOTOR_MOVE_L_CCW    p18
#define MOTOR_MOVE_L_PWM    p22
DigitalOut Move_l_Motor_CW(MOTOR_MOVE_L_CW);
DigitalOut Move_l_Motor_CCW(MOTOR_MOVE_L_CCW);
PwmOut Move_l_Motor_PWM(MOTOR_MOVE_L_PWM);

/***The pin is to conect to swing motor and interrupter.***/
#define MOTOR_SWING_PWM     p24
PwmOut Motor_swing(MOTOR_SWING_PWM);
#define ENCOD_SWING_A       p12
#define ENCOD_SWING_B       p11
#define ENCOD_SWING_Z       p15
QEI SwingSens(ENCOD_SWING_A, ENCOD_SWING_B, ENCOD_SWING_Z, 360, QEI::X4_ENCODING);
#define INTERRUPTER         p16
InterruptIn interrupter(INTERRUPTER);

/***indicator***/
DigitalOut Indicator1(LED1);
DigitalOut Indicator2(LED2);
DigitalOut Indicator3(LED3);
DigitalOut Indicator4(LED4);
DigitalOut IndicatorAuto(p17);
DigitalOut IndicatorRED(p5);
/////////////////////////////////////////////////////////////////////////

#endif /*PinDefine.h*/