/**
 * Includes
 */
#include "fusion_Motor.h"


fusion_Motor::fusion_Motor( QEI &p, PID &q, Motor &m): QEI(p),PID(q),Motor(m)
{
    flag=0;
    QEI::state(1);
    interval=0.3;
    Maxrpm=100.0F;
    Minrpm=-100.0F;
    Max=1;
    max=1;
    Min=-1;
    min=-1;
    mode = Normal;
    OutputLimits(1,-1);
}
void fusion_Motor::setup(Mode _mode)
{
    setmode(_mode);
}
void fusion_Motor::InterruptAction()
{
    //printf("%f\r\n",data);
    Motor::run(Free,data);
    switch(mode)
    {
        case Normal:
            inter.detach();
            break;
        case Servo:
            dPoint=getSumangle();
            PIDctrl();
            break;
        case Speed:
            RPM = dPoint=getRPM();
            PIDctrl();
            break;
    }
    Motor::operator=(data); 
}
void fusion_Motor::start(float target)
{
    dTarget=target;
    inter.attach(this,&fusion_Motor::InterruptAction,fusion_Motor::interval);
}
void fusion_Motor::start()
{
    inter.attach(this,&fusion_Motor::InterruptAction,fusion_Motor::interval);
}
void fusion_Motor::motor_run(float actionNum)
{
    switch(mode)
    {
        case Normal:
            Nomalrun(actionNum);
            break;
        case Servo:
            Servorun(actionNum);
            break;
        case Speed:
            Speedrun(flag?rerpmper(actionNum):rpmper(actionNum));
            break;
    }
}

float fusion_Motor::rpmper(float rpm)
{
    if(rpm>Maxrpm)rpm=Maxrpm;
    else if(rpm<Minrpm)rpm=Minrpm;
    return rpm;
}
float fusion_Motor::rerpmper(float rpm)
{
     if(rpm>Max)rpm=Max;
     else if(rpm<Min)rpm=Min;
     return rpmper(rpm*Maxrpm);
}






