#include "mbed.h"
#include "WatchDogTimer.h"

/*--------------------------------------------------------------------------------------------------
 Watchdogクラス
--------------------------------------------------------------------------------------------------*/
// WDT発生までの時間を秒数で指定する


Watchdog::Watchdog()
{          

} 

void Watchdog::kick(float s) 
{
    // WDTを動作可能にする P22
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<15); 
    // WDTクロックソースの選択
    //    b00 IRC発振器
    //    b01 メインクロック
    //    b10 WDT発振器
    LPC_SYSCON->WDTCLKSEL = 0x01;
    // WDTクロックソース更新
    LPC_SYSCON->WDTCLKUEN = 0;
    LPC_SYSCON->WDTCLKUEN = 1;
    while (!(LPC_SYSCON->WDTCLKUEN & 0x01));
    // WDTレジスタの設定（SystemCoreClock=48MHzの場合） P276
    LPC_SYSCON->WDTCLKDIV = 4;        // WDTクロック分周レジスタ（0=disable,1～255=分周値）
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
    LPC_WDT->TC = s * (float)clk;           // タイムアウト値を設定
    Watchdog::enable();                  // Enabled and Reset and reload
}
// WDTカウンタリロード
void Watchdog::kick(void) 
{
    //__disable_irq();
    LPC_WDT->FEED = 0xAA;
    LPC_WDT->FEED = 0x55;
    //__enable_irq();
}
// WDT有効
void Watchdog::enable(void) 
{
    LPC_WDT->MOD = 0x3;   // b1=resetを発生させる,b0=enable
    kick();
}
// WDT無効（debug用）
void Watchdog::disable() 
{
    LPC_WDT->MOD = 0x0;
}