/* 
 *mbed L6470 SPI Library
 */

#include "mbed.h"
#include "L6470.h"


        L6470::L6470(PinName mosi, PinName miso, PinName sclk, PinName cs,PinName busy)
        : m_spi(mosi, miso, sclk), m_cs(cs),m_busy(busy,PullUp)
        {
            //定義時に行う
            m_cs = 1;
            m_spi.format(8,3);
            m_spi.frequency(1000000);
            
            /*///前回の送りデータを流す
            send(0x00);
            send(0x00);
            send(0x00);
            send(0x00);
            /**/
        
        }
        void L6470::send(uint8_t temp)
        {
            //while(!m_busy){
            //} 
            m_cs = 0;//#cs = 1;
            temp = m_spi.write((uint8_t)temp);
            m_cs = 1;//#cs = 0;
             
            wait_us(0.5);

        }
        
        
        uint8_t L6470::send_r(uint8_t temp)
        {
            //while(!m_busy){
            //} 
            m_cs = 0;//#cs = 1;
            temp = m_spi.write((uint8_t)temp);
            m_cs = 1;//#cs = 0;
             
            wait_us(1);
            return temp;
        }
        
        void L6470::send_bytes(uint8_t temp[], int i)
        {
            while(0< i--)
            {
                send(temp[i]);
            }
        }
        
        void L6470::send_bytes_r(uint8_t temp[], int i)
        {
            while(0< i--)
            {
                temp[i] = send_r(temp[i]);
            }
        }
        
        
        
        
        void L6470::NOP()
        {
            send(0x00);
            
        }
        
        void L6470::SetParam(int param, int value)
        {   
            int n = (param>>8)/8;//配列の数
            int m = (param>>8)%8;//nは割り算だからあまりの分の値が取れないためこちらをif文に活用
            if(!m){
                uint8_t temp[n+1];
                temp[n] = 0x00 | (uint8_t)(param & 0xFF);
                while(0 < n--){//比較後マイナス
                    temp[n] = (uint8_t)(value >> 8*n )&0xFF;
                }
                send_bytes(temp,sizeof temp/sizeof temp[0]);
            
            }else{//余りが出た場合.　例 22とか7
                uint8_t temp[n+2];
                temp[n+1] = 0x00 | (uint8_t)(param & 0xFF);
                temp[n] = (uint8_t)(value >> 8*n)&~(0xFF<<m);//FFをずらしたあとで1の補数変換で反転.
                while(0 < n--){
                    temp[n]= (uint8_t)(value >> 8*n)&0xFF;
                }
                send_bytes(temp,sizeof temp/sizeof temp[0]);
            }    
        
        }
        int L6470::GetParam(int param)
        {
            int value  = 0;
            int n = (param>>8)/8;//配列の数
            int m = (param>>8)%8;//nは割り算だからあまりの分の値が取れないためこちらをif文に活用
            
            if(!m){
                uint8_t temp[n+1];
                for(int i = 0; i < n+1; i++){
                    temp[i] = 0;
                }
                temp[n] = 0x20|(uint8_t)(param&0xFF);
                send_bytes_r(temp,sizeof temp/sizeof temp[0]);
                while(0 < n--){
                    value |= (int)temp[n] << 8*n;
                }
                
            }else{
                n++;
                uint8_t temp[n+1];
                for(int i = 0; i < n+2; i++){
                    temp[i] = 0;
                }   
                temp[n] = 0x20|(uint8_t)(param&0xFF);
                send_bytes_r(temp,sizeof temp/sizeof temp[0]);
                while(0 < n--){
                    value |= (int)temp[n]<< 8*n;
                }
                
            } 
            
            return value;
        }
        
        
        
        void L6470::Run(bool dir, int speed)
        {
            uint8_t temp[4];
            temp[3] = 0x50|dir;
            temp[2] = (uint8_t)(speed >> 16)&0x0F;
            temp[1] = (uint8_t)(speed >>  8)&0xFF;
            temp[0] = (uint8_t)(speed >>  0)&0xFF;
            send_bytes(temp,sizeof temp/sizeof temp[0]);
        
        }
        
        void L6470::StepClock(bool dir)
        {
            send(0x58|dir);
        }
            
        void L6470::Move(bool dir,int n_step )
        {
            uint8_t temp[4];
            temp[3] = 0x40|dir;
            temp[2] = (uint8_t)(n_step >> 16)&0x3F;
            temp[1] = (uint8_t)(n_step >>  8)&0xFF;
            temp[0] = (uint8_t)(n_step >>  0)&0xFF;
            send_bytes(temp,sizeof temp/sizeof temp[0]);
            
        }
        void L6470::GoTo(int abs_pos)
        {
            uint8_t temp[4];
            temp[3] = 0x60;
            temp[2] = (uint8_t)(abs_pos >> 16)&0x3F;
            temp[1] = (uint8_t)(abs_pos >>  8)&0xFF;
            temp[0] = (uint8_t)(abs_pos >>  0)&0xFF;
            send_bytes(temp,sizeof temp/sizeof temp[0]);
   
        }
        
        void L6470::GoTo_dir(bool dir, int abs_pos)
        {
            uint8_t temp[4];
            temp[3] = 0x68|dir;
            temp[2] = (uint8_t)(abs_pos >> 16)&0x3F;
            temp[1] = (uint8_t)(abs_pos >>  8)&0xFF;
            temp[0] = (uint8_t)(abs_pos >>  0)&0xFF;
            send_bytes(temp,sizeof temp/sizeof temp[0]);
              
        }
        
        void L6470::GoUntill(bool act, bool dir, int speed)
        {
            uint8_t temp[4];
            temp[3] = 0x82|(act<<8)|dir;
            temp[2] = (uint8_t)(speed >> 16)&0x3F;
            temp[1] = (uint8_t)(speed >>  8)&0xFF;
            temp[0] = (uint8_t)(speed >>  0)&0xFF;
            send_bytes(temp,sizeof temp/sizeof temp[0]);
        }
    
        void L6470::ReleseSW(bool act,bool dir)
        {
            send(0x92|(act <<3)|dir);
        }
        void L6470::GoHome()
        {
            send(0x70);
        }
        
        void L6470::GoMark()
        {
            send(0x78);
        }
        
        void L6470::ResetPos()
        {
            send(0xD8);
        }
        
        void L6470::ResetDevice()
        {
            send(0xC0);
        }
        
        void L6470::SoftStop()
        {
            send(0xB0);
        }
        
        void L6470::HardStop()
        {
            send(0xB8);
        }
        
        void L6470::SoftHiz()
        {
            send(0xA0);
        }
        
        void L6470::HardHiz()
        {
            send(0xA8);
        }
        
        void L6470::Resets()
        {
            SoftStop();
            wait(0.5);
            ResetDevice();
            SetParam(ABS_POS,INI_ABS_POS);
            SetParam(EL_POS,INI_EL_POS);
            SetParam(MARK,INI_MARK);
            SetParam(SPEED,INI_SPEED);
            SetParam(ACC,INI_ACC);
            SetParam(DEC,INI_DEC);
            SetParam(MAX_SPEED,INI_MAX_SPEED);
            SetParam(MIN_SPEED,INI_MIN_SPEED);
            SetParam(KVAL_HOLD,INI_KVAL_HOLD);
            SetParam(KVAL_RUN,INI_KVAL_RUN);
            SetParam(KVAL_ACC,INI_KVAL_ACC);
            SetParam(KVAL_DEC,INI_KVAL_DEC);
            SetParam(INT_SPD,INI_INT_SPD);
            SetParam(ST_SLP,INI_ST_SLP);
            SetParam(FN_SLP_ACC,INI_FN_SLP_ACC);
            SetParam(FN_SLP_DEC,INI_FN_SLP_DEC);
            SetParam(K_THERM,INI_K_THERM);
            SetParam(OCD_TH,INI_OCD_TH);      
            SetParam(STALL_TH,INI_STALL_TH);
            SetParam(FS_SPD,INI_FS_SPD);
            SetParam(STEP_MODE,INI_STEP_MODE);
            SetParam(ALARM_EN,INI_ALARM_EN);
            SetParam(CONFIG,INI_CONFIG);               
            
        }
        
        void L6470::BusyWait(unsigned int time)
        {//BESYが解除されるまで待機
            while(!m_busy){
            }
            
            wait_ms(time);
        }
        
        void L6470::Step(int dosu)
        {
            //初期値180度とする
            int temp;
            
            temp = dosu*200/360;
            
            GoTo(temp);           
    
            
                        
        }
        

        
        
        
        
            
        
            
            