#include "mbed.h"

DigitalOut Led(LED1);
DigitalOut Val(LED2);
Serial pc(USBTX,USBRX);
I2C Sensor(p28,p27);

#define DEVICE_ADDRESS 0x2A << 1
#define CONTROL_REG 0x00
#define TIMING_REG_H 0x01
#define TIMING_REG_L 0x02

uint16_t red = 0;
uint16_t green = 0;
uint16_t blue = 0;
uint16_t IR = 0;

uint8_t address=DEVICE_ADDRESS;
char cmd[3]={
        CONTROL_REG
        ,TIMING_REG_H
        ,TIMING_REG_L
    };
char ord[2]={};
char data[8]={};

void led_blink(){
  Led=1;
  wait_ms(10);
  Led=0;
}

void setManualtGain(uint16_t ex_time)
{
  char reg[1]={0};
  
  reg[0] =(ex_time >>= 8);
  Sensor.write(address, reg, 1);
  reg[0] |= ex_time;
  Sensor.write(address, reg, 1);
}

void getRGB()
{
    
    /* //manual exposure mode
    
    setManualtGain(100);
    
    ord[0]=cmd[0];
    Sensor.write(address, ord, 1);
    
    ord[0]=0x84;// ADC reset LowGain wakeup
    Sensor.write(address, ord, 1);
    
    ord[0]=cmd[0];
    Sensor.write(address, ord, 1);
    
    ord[0]=0x04;//start
    Sensor.write(address, ord, 1);
    
    */
    
    //preset gain mode exposure time (each color ch)
    //  00 = 87.5us
    //  01= 1.4ms
    //  10= 22.4ms
    //  11= 179.2ms 
    
    
    ord[0]=0x00;
    ord[1]=0x89;
    Val = !Sensor.write(address&0xFE, ord, 2, true);
    
    ord[0]=0x00;
    ord[1]=0x09;
    Val = !Sensor.write(address&0xFE, ord, 2);
    
    
    //wait_ms(5.6*4); //total exposure time
    wait_ms(180*4); //total exposure time
    
    led_blink();
    
    //read data
    
    ord[0]=0x03;
    Val = !Sensor.write(address&0xFE, ord, 1, true);
    
    Val = !Sensor.read(address|0x01, data, 8, true);
    
    red     = (uint8_t)(data[0])<<8 | (uint8_t)(data[1]);
    green   = (uint8_t)(data[2])<<8 | (uint8_t)(data[3]);
    blue    = (uint8_t)(data[4])<<8 | (uint8_t)(data[5]);
    IR      = (uint8_t)(data[6])<<8 | (uint8_t)(data[7]);
    
    return;
}

int main()
{
    Sensor.frequency(100000);
    Led=0;
    led_blink();
    
    while(1)
    {    
        getRGB();
        
        pc.printf("Red = %4d, Green = %4d, Blue = %4d\n"
            ,red
            ,green
            ,blue
        );
        wait_ms(500);
    }
}
