
#ifndef L6470_STEP_H
#define L6470_STEP_H

//Brid. respected
#include "mbed.h"

//config name.reset data;
//first init config data.
#define INI_ABS_POS    0
#define INI_EL_POS     0
#define INI_MARK       180
#define INI_SPEED      0
#define INI_ACC        0x8A//8A//0010
#define INI_DEC        0x8A
#define INI_MAX_SPEED  0x20
#define INI_MIN_SPEED  0
#define INI_FS_SPD     0x27
#define INI_KVAL_HOLD  0x3F
#define INI_KVAL_RUN   0xFF
#define INI_KVAL_ACC   0x70 
#define INI_KVAL_DEC   0x70
#define INI_INT_SPD    0x408
#define INI_ST_SLP     0x19
#define INI_FN_SLP_ACC 0x29
#define INI_FN_SLP_DEC 0x29
#define INI_K_THERM    0 
//      INI_ADC_OUT read only desu.    
#define INI_OCD_TH     0xF0
#define INI_STALL_TH   0x7F
#define INI_STEP_MODE  0x70
#define INI_ALARM_EN   0xFF
#define INI_CONFIG     0x2E98
//      INI_STATUS read only desu.   




//レジスタのアドレス
// name length<<8 + address
#define ABS_POS    ((22<<8)+0x01)
#define EL_POS      ((9<<8)+0x02)
#define MARK       ((22<<8)+0x03)
#define SPEED      ((20<<8)+0x04)
#define ACC        ((12<<8)+0x05)
#define DEC        ((12<<8)+0x06)
#define MAX_SPEED  ((10<<8)+0x07)
#define MIN_SPEED  ((13<<8)+0x08)
#define FS_SPD     ((10<<8)+0x15)
#define KVAL_HOLD   ((8<<8)+0x09)
#define KVAL_RUN    ((8<<8)+0x0A)
#define KVAL_ACC    ((8<<8)+0x0B)
#define KVAL_DEC    ((8<<8)+0x0C)
#define INT_SPD    ((14<<8)+0x0D)
#define ST_SLP      ((8<<8)+0x0E)
#define FN_SLP_ACC  ((8<<8)+0x0F)
#define FN_SLP_DEC  ((8<<8)+0x10)
#define K_THERM     ((4<<8)+0x11)
#define ADC_OUT     ((5<<8)+0x12)
#define OCD_TH      ((4<<8)+0x13)
#define STALL_TH    ((7<<8)+0x14)
#define STEP_MODE   ((8<<8)+0x16)
#define ALARM_EN    ((8<<8)+0x17)
#define CONFIG     ((16<<8)+0x18)
#define STATUS     ((16<<8)+0x19)

class L6470{

    public:
    
        /** 
         *
         * @param mosi SPI mosi pin
         * @param miso SPI miso pin
         * @param sck  SPI sck  pin
         * @param _cs  #cs pin
         * 
         */ 
         
        L6470(PinName mosi, PinName miso, PinName sck, PinName cs, PinName busy);
        
        void send(uint8_t temp);
        uint8_t send_r(uint8_t temp);
        void send_bytes(uint8_t temp[], int i);
        void send_bytes_r(uint8_t temp[], int i);
        void NOP();
        void SetParam(int param, int value);
        int  GetParam(int param);
        void Run(bool dir, int speed);
        void StepClock(bool dir);
        void Move(bool dir,int n_step );//n_step--22bit
        void GoTo(int abs_pos);
        void GoTo_dir(bool dir, int abs_pos);
        void GoUntill(bool act, bool dir, int speed);
        void ReleseSW(bool act,bool dir);
        void GoHome();
        void GoMark();
        void ResetPos();
        void ResetDevice();
        void SoftStop();
        void HardStop();
        void SoftHiz();
        void HardHiz();
        void Resets();
        void BusyWait(unsigned int time);
        void Step(int dosu);
        bool BusyCheck();

       

    protected:

        SPI m_spi;
        DigitalOut m_cs;
        DigitalIn m_busy;
        
        

};
#endif















