
    
 #ifndef MBED_IRM_H
 #define MBED_IRM_H

#include "mbed.h"

#define NAKATA 833 //周期833us
#define NOT_F 0

/** IRM2121  class, based on an DigitalIn pin, and a timer
 *  use RoboCup Junior Soccer to find PULSE BALL.
 
 
 * Example:
 * @code
 * // Set Digital and read sensor.
 * #include "mbed.h"
 * #include "IRM2121.h"
 * IRM2121 IR(p21);
 * 
 * int main() {
 *     int length;
 
 *     while(1) {
 *  
 *        IR.Set();    
 *        wait_ms(20); //check _Busy 1 &_Valid 0 ....config just wait time.
 *        length = IR.Read();
 *     }
 * }
 * @endcode
 */
class IRM2121 {
  public:
    /** Create a IRM2121 object connected to the specified InterruptIn pin
    *
    * @param IRM_PIN InterruptIn pin to connect to 
    */
    IRM2121(PinName IRM_PIN);
    
    unsigned int Read (void);    
     /** Set a IRM2121 Interrupt Pin 
      *
      * @param none
      */
        
    /** Read the result 
      *
      * @param none
      */
    
  private:
    
    DigitalIn       _pin;
    Timer           _timer;

    unsigned int _Time;
      
  };
  
  #endif