/*
メインと通信するLPC1114のプログラム()

現在は両方がmainと通信します．


*/

#include "mbed.h"

#define SYSAHBCLKDIV_Val      0x00000001        // Reset: 0x001
#define CLOCK_SETUP           1                  // デフォルト=1
#define SYSPLLCTRL_Val        0x00000023        // デフォルト=23 Reset: 0x000
#define SYSPLLCLKSEL_Val      0x00000001        // デフォルト=0  Reset: 0x000
#define MAINCLKSEL_Val        0x00000003        // デフォルト=3  Reset: 0x000

#include "IRM2121.h"
#include "Ping.h"

#define PING_COUNT 5 //5回に1回にPing処理
#define LINE_LINE 0.45 //すごく雑 

IRM2121 Ir[6] = {dp17,dp18,dp24,dp25,dp26,dp28};
Ping Ping1(dp1,dp2);
Ping Ping2(dp4,dp6); 
AnalogIn Line[4] ={dp9,dp10,dp11,dp13};
DigitalOut Led(LED1);

I2CSlave Mbed(dp5,dp27);//sda,scl
Serial pc(USBTX,USBRX);


uint8_t IrMovig_ave(uint8_t num, int data){
    static unsigned int sum[6];
    static unsigned temp[6][5];
    
    sum[num] -= temp[num][4]; 
    sum[num] += data;
    
    temp[num][4] = temp[num][3];
    temp[num][3] = temp[num][2];
    temp[num][2] = temp[num][1];
    temp[num][1] = temp[num][0];
    temp[num][0] = data;
    
    return  sum[data]/5;   
}



void ResetSet(uint8_t *PingCk){

    Led = 1;//周回の初め    
    PingCk ++;

}



int main() {
    
    //default Mbed.frequency();
    Mbed.address(0x0A);
    /*Data*/
    uint8_t IrMemory[6] = {0};//IRのデータ保管
    uint8_t PingMemory[2] = {0};
    unsigned int LineMemory[4] = {0};
    
    /*Flag*/
    uint8_t LineFlag;//配置 - - - - Line[3] Line[2] Line[1] Line[0]
    
    /*Count*/
    uint8_t PingCk = 0;
    
    /* I2Cdata*/
    char SendData[9]={0};

    while(1) {
        
        ResetSet(&PingCk);
        Ir[0].Set();
        Ir[1].Set();
        Ir[2].Set();
        Ir[3].Set();
        Ir[4].Set();
        Ir[5].Set();
        
        wait_ms(30);//wait値は最適値を探す必要がある．
        
        IrMemory[0] = IrMovig_ave(0,Ir[0].Read());
        IrMemory[1] = IrMovig_ave(1,Ir[1].Read());
        IrMemory[2] = IrMovig_ave(2,Ir[2].Read());
        IrMemory[3] = IrMovig_ave(3,Ir[3].Read());
        IrMemory[4] = IrMovig_ave(4,Ir[4].Read());
        IrMemory[5] = IrMovig_ave(5,Ir[5].Read());
        
        /*大きい二つだけでいい気がする．*/
        if(PingCk >= PING_COUNT){
            Ping1.Send();
            Ping2.Send();    
            wait_ms(30);
            PingMemory[0] = Ping1.Read_cm();
            PingMemory[1] = Ping2.Read_cm();
            PingCk = 0;
        }
        
        LineMemory[0] = Line[0];
        LineMemory[1] = Line[1];
        LineMemory[2] = Line[2];
        LineMemory[3] = Line[3];
        
        LineFlag = ((int)(LineMemory[3]+LINE_LINE))*8 +
                   ((int)(LineMemory[2]+LINE_LINE))*4 +
                   ((int)(LineMemory[1]+LINE_LINE))*2 +
                   ((int)(LineMemory[0]+LINE_LINE))*1;
           
        SendData[0] = (char)IrMemory[0];
        SendData[1] = (char)IrMemory[1];
        SendData[2] = (char)IrMemory[2];
        SendData[3] = (char)IrMemory[3];
        SendData[4] = (char)IrMemory[4];
        SendData[5] = (char)IrMemory[5];
        SendData[6] = (char)PingMemory[0];
        SendData[7] = (char)PingMemory[1];
        SendData[8] = (char)LineFlag;
        
        switch(Mbed.receive()){    
            case I2CSlave::ReadAddressed:
                 Mbed.write(SendData, 9); // Includes null char
                 break;
             case I2CSlave::WriteGeneral:
                 break;
             case I2CSlave::WriteAddressed:
                 break;
        
        }
    
        Led = 0;
    
    }
}
