
/*PID処理*/
#define RATE    0.052//52
#define PID_BIAS    0.1
#define REFERENCE   180.0
#define MINIMUM     0.1
#define MAXIMUM     360.0
#define P_GAIN  1.8//1.4    //0.78   
#define I_GAIN  0.0     //0.0
#define D_GAIN  0.03  //0.009
#define OUT_LIMIT   50.0
#define MAX_POW     100
#define MIN_POW     -100

/*回り込みの計算用*/
#define PI 3.1415926

/*LPC1114 I2C Slave Address*/
#define ADDRESS_R 0xAA
#define ADDRESS_L 0xAC

/*BusIn sw　入力値*/
#define StartS 0x01
#define Debug1 0x02
#define Debug2 0x04
#define Debug3 0x06
#define Kicker 0x08
#define Calibration 0x10


#define CW 1
#define CCW -1
#define ENTER   0
#define EXIT    1


BusIn   Sw(p22,p23,p24,p25,p26);
BusIn   Line(p5,p6,p7,p8);//No reading line → 0b1111 ,not pull up
DigitalOut  Led[4] = {LED1,LED2,LED3,LED4};
DigitalOut  Kick(p29);

Servo       S555(p21);
I2C         Sensor(p9,p10);//sda,scl
HMC6352     hmc6352(p9,p10);//sda,scl
AQM0802A    Lcd(p28,p27);//sda,scl
Serial      Motor(p13,p14);//tx,rx
Serial      pc(USBTX,USBRX);

/*Compass PID SetUp*/
PID pid(P_GAIN,I_GAIN,D_GAIN, RATE);

extern string StringFIN;
extern void array(int,int,int,int);

int speed[4] = {0};            
typedef enum {FRONT = 1, RIGHT, BACK, LEFT, NA} Direction;
enum {SONIC = 0x01, BALL};
int SetRad = 0;

int TargetCoordinates[12][2][2] = {
    {{0,1},{0,1}},//p,q+6
    {{0,1},{0,1}},//p,q+5
    {{0,1},{0,1}},//p,q+4
    {{0,1},{0,1}},//p,q+3
    {{0,1},{0,1}},//p,q+2
    {{0,1},{0,1}},//p,q+1
    {{0,1},{0,1}},//p,q
    {{0,1},{0,1}},//p-1,q
    {{0,1},{0,1}},//p-2,q
    {{0,1},{0,1}},//p-3,q
    {{0,1},{0,1}},//p-4,q
    {{0,1},{0,1}},//0,q
    };
    
volatile  int Angle[180] = {
    0   ,   1   ,   2   ,   3   ,
    4   ,   5   ,   6   ,   7   ,
    8   ,   9   ,   10  ,   11  ,
    12  ,   13  ,   14  ,   15  ,
    16  ,   17  ,   18  ,   19  ,
    20  ,   21  ,   22  ,   23  ,
    24  ,   25  ,   26  ,   27  ,
    28  ,   29  ,   30  ,   31  ,
    32  ,   33  ,   34  ,   35  ,
    36  ,   37  ,   38  ,   39  ,
    40  ,   41  ,   42  ,   43  ,
    44  ,   45  ,   46  ,   47  ,
    48  ,   49  ,   50  ,   51  ,
    52  ,   53  ,   54  ,   55  ,
    56  ,   57  ,   58  ,   59  ,
    60  ,   61  ,   62  ,   63  ,
    64  ,   65  ,   66  ,   67  ,
    68  ,   69  ,   70  ,   71  ,
    72  ,   73  ,   74  ,   75  ,
    76  ,   77  ,   78  ,   79  ,
    80  ,   81  ,   82  ,   83  ,
    84  ,   85  ,   86  ,   87  ,
    88  ,   89  ,   90  ,   -89 ,
    -88 ,   -87 ,   -86 ,   -85 ,
    -84 ,   -83 ,   -82 ,   -81 ,
    -80 ,   -79 ,   -78 ,   -77 ,
    -76 ,   -75 ,   -74 ,   -73 ,
    -72 ,   -71 ,   -70 ,   -69 ,
    -68 ,   -67 ,   -66 ,   -65 ,
    -64 ,   -63 ,   -62 ,   -61 ,
    -60 ,   -59 ,   -58 ,   -57 ,
    -56 ,   -55 ,   -54 ,   -53 ,
    -52 ,   -51 ,   -50 ,   -49 ,
    -48 ,   -47 ,   -46 ,   -45 ,
    -44 ,   -43 ,   -42 ,   -41 ,
    -40 ,   -39 ,   -38 ,   -37 ,
    -36 ,   -35 ,   -34 ,   -33 ,
    -32 ,   -31 ,   -30 ,   -29 ,
    -28 ,   -27 ,   -26 ,   -25 ,
    -24 ,   -23 ,   -22 ,   -21 ,
    -20 ,   -19 ,   -18 ,   -17 ,
    -16 ,   -15 ,   -14 ,   -13 ,
    -12 ,   -11 ,   -10 ,   -9  ,
    -8  ,   -7  ,   -6  ,   -5  ,
    -4  ,   -3  ,   -2  ,   -1  };

volatile int  RadToVector[4] = {1,-1,-1,1};

    
/*
    |               |
    |               |
    |       o       |
    |               |
    |               |
    |---------------p,q
    
    
*/