#include "mbed.h"
#include "extern.h"

uint8_t ZeroFunction(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    if(x==1){
        sprintf(buf, "%2d%.14s", sys.strategy, act[sys.strategy].LcdStr);
        Lcd.locate(0, 1);Lcd.print(buf);wait_ms(50);return 0;
    }
    else if(x==2){
        sprintf(buf, "%2d:S%2d M%2d L%2d", 
            sys.pow_num, 
            ir_pow_val[sys.pow_num][POW_SHORT], 
            ir_pow_val[sys.pow_num][POW_MIDDLE], 
            ir_pow_val[sys.pow_num][POW_LONG]
        );
        Lcd.locate(0, 1);Lcd.print(buf);
        return 0;
    }
    else{//x==3
        sprintf(buf, "SeeYouAgain!");
        Lcd.locate(0, 1);Lcd.print(buf);wait(0.5);
        NVIC_SystemReset();
        return 1;
    }
}
uint8_t Start(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t temp;
    temp = sys.strategy;
    sprintf(buf, "CatPot");
    Lcd.locate(0, 1);Lcd.print(buf);
    sys.strategy=0;
    sys.TurnStartFlag=0;
    Active();
    sys.strategy=temp;
    //reset
    NVIC_SystemReset();
    return 1;
}
uint8_t TurnAndStart(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t temp;
    temp = sys.strategy;
    sprintf(buf, "CatPot");
    Lcd.locate(0, 1);Lcd.print(buf);
    sys.strategy=0;
    sys.TurnStartFlag=1;
    Active();
    sys.strategy=temp;
    //reset
    NVIC_SystemReset();
    return 1;
}
uint8_t GetIr(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    ReadIr();
    
    //if(x==1) sprintf(buf, "SHRT:%2d, LNG:%2d", data.irSpot[0], data.irSpot[1]);
    //if(x==2) sprintf(buf, "NOTE:%2d", data.irNotice);
    //if(x==3) sprintf(buf, "POSITION:%2d", data.irPosition);
    if(x==1) sprintf(buf, "POSI:%2d NOTE:%1d", data.irPosition, data.irNotice);
    if(x==2) sprintf(buf, "PH_L:%1d PH_S:%1d", data.irValPhase[IR_LONG], data.irValPhase[IR_SHORT]);
    if(x==3) sprintf(buf, "DIF:%1d KEY:%2d", data.irDif[IR_LONG], data.irKey);
    Lcd.locate(0, 1);Lcd.print(buf);wait_ms(50);return 0;
}
uint8_t GetSns0(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t raw[3];
    uint8_t held[3];
    if(x==1){
        LineKeeper=LINE_FIX;//line
        
        raw[2] = GetBit(LineRaw, 3);
        raw[1] = GetBit(LineRaw, 2);
        raw[0] = GetBit(LineRaw, 1);
        
        held[2] = GetBit(LineHold, 3);
        held[1] = GetBit(LineHold, 2);
        held[0] = GetBit(LineHold, 1);
        //BusOut LineKeeper(lineInA, lineInB, lineInC);
        //BusIn LineRaw(lineA2, lineB2, lineC2);
        //BusIn LineHold(lineA1, lineB1, lineC1);
        sprintf(buf, "A:%1d%1d B:%1d%1d C:%1d%1d ", raw[0],held[0],raw[1],held[1],raw[2],held[2]);
        //sprintf(buf, "A:%1d B:%1d C:%1d ", Line[0].read(), Line[1].read(), Line[2].read());
        Lcd.locate(0, 1);Lcd.print(buf);wait_ms(50);return 0;
    }
    if(x==2){
        ReadPing2();
        ReadPing();
        sprintf(buf, "L%3dR%3dF%3dB%3d", data.ping[L_PING], data.ping[R_PING], data.ping[F_PING], data.ping[B_PING]);
        Lcd.locate(0, 1);Lcd.print(buf);wait_ms(50);return 0;
    }
    if(x==3){
        //ReadIr();
        //sprintf(buf, "IR_KEY:%2d", data.irKey);
        //sprintf(buf, "BALL:%1d", BallChecker.read());
        sprintf(buf, "BALLA%6d", BallCheckerA.read_u16());
        Lcd.locate(0, 1);Lcd.print(buf);wait_ms(50);return 0;
    }
    return 0;
}
uint8_t RwPid(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    if(x==1){
        PidUpdate();
        sprintf(buf, "In:%03.0f Out:%+02d", cmps_set.InputPID, cmps_set.OutputPID);
        Lcd.locate(0, 1);Lcd.print(buf);wait_ms(50);return 0;
    }
    if(x==2){
        sys.jump_flag=START;
        sprintf(buf, "FaceToFront!");
        Lcd.locate(0, 1);Lcd.print(buf);
        hmc_reset = HMC_RST;
        wait_ms(100);
        hmc_reset = HMC_RUN;
        for(int i=0; i<5; i++){
            ReadCmps();
            cmps_set.CmpsInitialValue = cmps_set.cmps;
            wait_ms(100);
        }
        cmps_set.CmpsDiff = REFERENCE - cmps_set.cmps;
        cmps_set.FrontDeg=0;
        return 1;
    }
    return 1;
}
uint8_t CalibrationEnterOrExit(uint8_t x){
    static uint8_t state=0;
    char buf[LCD_COLUMN_NUM];
    
    if(x==1){
        if(state==0){
            sprintf(buf, "Exit>>Enter");
        }
        if(state==1){
            sprintf(buf, "Enter>>Exit");
        }
        Lcd.locate(0, 1);Lcd.print(buf);
        return 0;
    }
    if(x==2){
        if(state==0){
            hmc.setCalibrationMode(HMC6352_ENTER_CALIB);
            state=1;
            return 1;
        }
        if(state==1){
            hmc.setCalibrationMode(HMC6352_EXIT_CALIB);
            state=0;
            return 1;
        }
    }
    return 1;
}
uint8_t CalibrationTurn(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    sprintf(buf, "CalibrationTurn");
    Lcd.locate(0, 1);Lcd.print(buf);
    hmc.setCalibrationMode(HMC6352_ENTER_CALIB);wait_ms(20);
    move(0,0,5);tx_motor();
    wait(5);
    move(0,0,0);tx_motor();
    hmc.setCalibrationMode(HMC6352_EXIT_CALIB);wait_ms(20);
    sys.jump_flag=GET_PID_VALUE;
    return 1;
}
uint8_t SetPowerUp(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t i=(sys.pow_num+(-1+POW_COMBI_NUM))%POW_COMBI_NUM;
    if(x==1){
        sprintf(buf, "%2d:S%2d M%2d L%2d", i, ir_pow_val[i][POW_SHORT], ir_pow_val[i][POW_MIDDLE], ir_pow_val[i][POW_LONG]);
        Lcd.locate(0, 1);Lcd.print(buf);
        return 0;
    }
    else{//x==2
        sys.pow_num = i;
        sys.s_pow = ir_pow_val[sys.pow_num][POW_SHORT];
        sys.m_pow = ir_pow_val[sys.pow_num][POW_MIDDLE];
        sys.l_pow = ir_pow_val[sys.pow_num][POW_LONG];
        return 1;
    }
}
uint8_t SetPowerDown(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t i=(sys.pow_num+1)%POW_COMBI_NUM;
    if(x==1){
        sprintf(buf, "%2d:S%2d M%2d L%2d", i, ir_pow_val[i][POW_SHORT], ir_pow_val[i][POW_MIDDLE], ir_pow_val[i][POW_LONG]);
        Lcd.locate(0, 1);Lcd.print(buf);
        return 0;
    }
    else{//x==2
        sys.pow_num = i;
        sys.s_pow = ir_pow_val[sys.pow_num][POW_SHORT];
        sys.m_pow = ir_pow_val[sys.pow_num][POW_MIDDLE];
        sys.l_pow = ir_pow_val[sys.pow_num][POW_LONG];
        return 1;
    }
}
uint8_t SoftReset(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    sprintf(buf, "SeeYouAgain!");
    Lcd.locate(0, 1);Lcd.print(buf);wait(0.5);
    NVIC_SystemReset();
    return 1;
}
uint8_t SetStrategyUp(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t i=(sys.strategy+(-1+STRATEGY_NUM))%STRATEGY_NUM;
    if(x==1){
        sprintf(buf, "%2d:%.12s", i, act[i].LcdStr);
        Lcd.locate(0, 1);Lcd.print(buf);
        return 0;
    }
    else{//x==2
        sys.strategy = i;
        return 1;
    }
}
uint8_t SetStrategyDown(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    uint8_t i=(sys.strategy+1)%STRATEGY_NUM;
    if(x==1){
        sprintf(buf, "%2d:%.12s", i, act[i].LcdStr);
        Lcd.locate(0, 1);Lcd.print(buf);
        return 0;
    }
    else{//x==2
        sys.strategy = i;
        return 1;
    }
}
uint8_t Start2(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    sprintf(buf, "CatPotForDebug");
    Lcd.locate(0, 1);Lcd.print(buf);
    sys.TurnStartFlag=0;
    Active();
    return 1;
}
uint8_t DriveKicker(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    sprintf(buf, "KickForDebug");
    Lcd.locate(0, 1);Lcd.print(buf);
    wait(2);
    kicker = 1;
    wait(.5);
    kicker = 0;
    wait(.5);
    return 1;
}
uint8_t DriveDribblerAndKicker(uint8_t x){
    char buf[LCD_COLUMN_NUM];
    sprintf(buf, "DribbleForDebug");
    Lcd.locate(0, 1);Lcd.print(buf);
    sys.DribbleFlag=1;wait_ms(20);move(0,0,0);tx_motor();
    wait(5);
    kicker = 1;
    wait(.5);
    kicker = 0;
    wait(2);
    sys.DribbleFlag=0;wait_ms(20);move(0,0,0);tx_motor();
    return 1;
}