#ifndef _MAIN_H_
#define _MAIN_H_

#include "def.h"

//pc(Computer)
RawSerial pc(monitor_tx, monitor_rx);
//led(main)
//DigitalOut LED[4]={led1, led2, led3, led4};
BusOut LED(led1, led2, led3, led4);
//line(bottom)
BusOut LineKeeper(lineInA, lineInB, lineInC);
BusIn LineRaw(lineA2, lineB2, lineC2);
BusIn LineHold(lineA1, lineB1, lineC1);
InterruptIn Line[3]={lineA2, lineB2, lineC2};
InterruptIn LineHolding[3]={lineA1, lineB1, lineC1};
//ballcheck(bottom)
InterruptIn BallChecker(ballcheck);
AnalogIn BallCheckerA(ballcheck);
//debug_switch(debug_board)
DigitalIn Sw[4] = {selectsw1, selectsw2, debugsw1, debugsw2};
//motor(main)
Serial motor(motor_tx, motor_rx);
//spi(main)
SPI spi(SPI_mosi, SPI_miso, SPI_slck);
DigitalOut spi_ss[4]={SPI_ss_sd, SPI_ss_sonic, SPI_ss_color, SPI_ss_ir};
//bluetooth(debug_board)
RawSerial RN42(blue_rxd, blue_txd);
DigitalOut hmc_reset(blue_reset);
//lcd(debug_board)
AQM1602 Lcd(lcd_sda, lcd_scl);
//cmps(debug_board)
HMC6352 hmc(sens_sda, sens_scl);
//mouse(bottom)
adns_9800 mouse_sensor(mouse_mosi, mouse_miso, mouse_slck, mouse_ss);
//solenoid(bottom)
DigitalOut kicker(solenoid);

//Serial for motors
int speed[4]={0};
string StringFIN;
//PID
PID pid(P_GAIN,I_GAIN,D_GAIN, RATE);
//Ticker pidupdate;
//for Serial
volatile uint8_t INdata[DATA_NUM]={0}, EXdata[DATA_NUM]={0};
//for DataSet
//Record data;
//NewStruct
CompassVal cmps_set;
SensorVal data;
SystemVal sys;
//for transition
Ticker Sw_ticker;
Timeout button;
bool state[4]={0,0,0,0};
uint8_t statesum=0, last_statesum=0;
// for Time
Ticker Motor_ticker;
//Ticker Line_ticker;
Ticker Info_ticker;
//Ticker Hmc_ticker;

//Timeout Line_timeout[3];
Timeout Line_reset;

Timeout Solenoid_timeout;
Timeout Kick_stop;

Timeout Turn_timeout;
Timeout Turn_stop;

Timeout Ball_judge;

//Timeout Kick_now;
//Timeout Front_now;
//Timeout Line_home;

Ticker Duty[DUTY_NUM];
Timeout Stp;
double dutycycle[DUTY_NUM] ={//[s]
    0.2
};

#endif /*_MAIN_H_*/