#ifndef _EXTERN_H_
#define _EXTERN_H_

#include "def.h"

/*追加ライブラリ*/
#include <sstream>
#include "math.h"
#include "AQM1602.h"
#include "HMC6352.h"
#include "PID.h"

#include "adns_9800.h"
#include "txrx.h"
#include "switch.h"
#include "wordString2.h"
#include "IrConfig.h"
#include "LineConfig.h"

#include "setup.h"
#include "command.h"
#include "command_functions.h"
#include "active.h"
#include "input.h"
#include "output.h"
#include "LineProcess.h"
#include "strategy.h"
#include "strategy2.h"
#include "old_strategy.h"

#include "PinConfig.h"
#include "CommandConfig.h"
#include "ActiveConfig.h"
#include "MathTable.h"
/*クラス*/

//pc(Computer)
extern RawSerial pc;
//led(main)
//extern DigitalOut LED[4];
extern BusOut LED;
//line(bottom)
extern BusOut LineKeeper;
extern BusIn LineRaw;
extern BusIn LineHold;
extern InterruptIn Line[3];
extern InterruptIn LineHolding[3];
//ballcheck(bottom)
extern InterruptIn BallChecker;
extern AnalogIn BallCheckerA;
//debug_switch(debug_board)
extern DigitalIn Sw[4];
//motor(main)
extern Serial motor;
//spi(main)
extern SPI spi;
extern DigitalOut spi_ss[4];
//bluetooth(debug_board)
extern RawSerial RN42;
extern DigitalOut hmc_reset;
//lcd(debug_board)
extern AQM1602 Lcd;
//cmps
extern HMC6352 hmc;
//mouse(bottom)
extern adns_9800 mouse_sensor;
//solenoid(bottom)
extern DigitalOut kicker;

//Serial for motors
extern int speed[4];
extern string StringFIN;
//PID
extern PID pid;
extern Ticker pidupdate;
//for Serial
extern volatile uint8_t INdata[DATA_NUM], EXdata[DATA_NUM];
//for DataSet
//extern Record data;
//NewStruct
extern CompassVal cmps_set;
extern SensorVal data;
extern SystemVal sys;
//for transition
extern Ticker Sw_ticker;
extern Timeout button;
extern bool state[4];
extern uint8_t statesum, last_statesum;
// for Time
extern Ticker Motor_ticker;
//extern Ticker Line_ticker;
extern Ticker Info_ticker;
//extern Ticker Hmc_ticker;

//extern Timeout Line_timeout[3];
extern Timeout Line_reset;

extern Timeout Solenoid_timeout;
extern Timeout Kick_stop;

extern Timeout Turn_timeout;
extern Timeout Turn_stop;

extern Timeout Ball_judge;

//extern Timeout Kick_now;
//extern Timeout Front_now;
//extern Timeout Line_home;

extern Ticker Duty[DUTY_NUM];
extern Timeout Stp;
extern double dutycycle[DUTY_NUM];

#endif /*_EXTERN_H_*/