#include "mbed.h"
#include "extern.h"

void Active(void){
    uint8_t i;
    void (*DutyFunction[DUTY_NUM])(void) = {
        Active2Command
    };
    for(i=0; i<DUTY_NUM; i++){
        Duty[i].attach(DutyFunction[i], dutycycle[i]);
    }
    sys.stopflag=0;
    //スタート直前の処理
    SetUp2();
    while(1){
        //pc.printf("sys.stopflag=%d\r\n", sys.stopflag);
        //StrategyFunction[sys.strategy]();
        act[sys.strategy].ActiveFunction();
        if(sys.stopflag==1){
            //システム上の停止処理
            button.detach();
            last_statesum = statesum = 0;
            state[0] = state[1] = state[2] = state[3] = 0;
        
            for(i=0; i<DUTY_NUM; i++){
                Duty[DUTY_SW].detach();
            }
            sys.stopflag=0;
            //その他停止処理
            StopProcess();
            break;
        }
    }
    return;
}
void Active_old(void){
    uint8_t i;
    void (*DutyFunction[DUTY_NUM])(void) = {
        Active2Command
    };
    void (*StrategyFunction[STRATEGY_NUM])(void) = {
        //modeAttack5,
        modeAttack2,
        //modeAttack4,
        modeAttack1,
        modeAttack2,
        modeAttack3,
        modeAttack4,
        modeAttack5,
        
        modeDebug0,
        modeDebug1,
        modeDebug2,
        modeDebug3,
        modeDebug4,
        modeDebug5,
    };
    for(i=0; i<DUTY_NUM; i++){
        Duty[i].attach(DutyFunction[i], dutycycle[i]);
    }
    sys.stopflag=0;
    //スタート直前の処理
    SetUp2();
    while(1){
        //pc.printf("sys.stopflag=%d\r\n", sys.stopflag);
        StrategyFunction[sys.strategy]();
        if(sys.stopflag==1){
            //システム上の停止処理
            button.detach();
            last_statesum = statesum = 0;
            state[0] = state[1] = state[2] = state[3] = 0;
        
            for(i=0; i<DUTY_NUM; i++){
                Duty[DUTY_SW].detach();
            }
            sys.stopflag=0;
            //その他停止処理
            StopProcess();
            break;
        }
    }
    return;
}
//for transition
void ResetState(void){
    last_statesum = statesum = 0;
    state[0] = state[1] = state[2] = state[3] = 0;
}
void Active2Command(void){
    uint8_t i;
    for(i=0; i<4; i++){
        if(CountSw(i)==1) state[i]=1;
    }
    last_statesum = statesum;
    statesum = state[0]+state[1]+state[2]+state[3];
    if((statesum>=1)&&(!(statesum==last_statesum))){
        button.attach(&ResetState, 1.0);
    }
    if((statesum>=2)&&(1)){
        if((state[0]==1)&&(state[1]==1)&&(state[2]==0)&&(state[3]==0)){
            sys.stopflag=1;
        }
        else{
            button.detach();
            ResetState();
        }
    }
}