#ifndef _MAIN_H_
#define _MAIN_H_

#include "def.h"

//PinConfig

//超音波用(20pin)
#ifdef ULTRA_SONIC

static PinName const monitor_tx = P0_4;
static PinName const monitor_rx = P0_0;

static PinName const write_rx = P0_0;
static PinName const write_tx = P0_4;
static PinName const write_reset = P0_5;
static PinName const write_isp = P0_12;

static PinName const SPI_mosi = P0_10;
static PinName const SPI_miso = P0_11;
static PinName const SPI_slck = P0_1;
static PinName const SPI_ss_sonic = P0_15;

static PinName const Sonic1_echo = P0_23;
static PinName const Sonic2_echo = P0_17;

static PinName const led_umr1 = P0_14;
static PinName const led_umr2 = P0_13;

Serial pc(monitor_tx, monitor_rx);
SPISlave nucleo(SPI_mosi, SPI_miso, SPI_slck, SPI_ss_sonic);
InterruptIn call(SPI_ss_sonic);
Ping rear(Sonic1_echo);
Ping front(Sonic2_echo);
DigitalOut led[2]={led_umr1, led_umr2};
#endif /*ULTRA_SONIC*/


//超音波用onDebugBoard(20pin)
#ifdef ULTRA_SONIC_2

static PinName const monitor_tx = P0_4;
static PinName const monitor_rx = P0_0;

static PinName const write_rx = P0_0;
static PinName const write_tx = P0_4;
static PinName const write_reset = P0_5;
static PinName const write_isp = P0_12;

static PinName const SPI_mosi = P0_10;
static PinName const SPI_miso = P0_11;
static PinName const SPI_slck = P0_1;
static PinName const SPI_ss_sonic = P0_15;

static PinName const Sonic1_trg = P0_23;
static PinName const Sonic2_trg = P0_17;

static PinName const Sonic4_trg = P0_14;
static PinName const Sonic3_trg = P0_13;

Serial pc(monitor_tx, monitor_rx);
SPISlave nucleo(SPI_mosi, SPI_miso, SPI_slck, SPI_ss_sonic);
InterruptIn call(SPI_ss_sonic);
Ping rear(Sonic1_trg);
Ping front(Sonic2_trg);
DigitalOut led[2]={Sonic4_trg, Sonic3_trg};
#endif /*ULTRA_SONI_2*/

//IRセンサー用(33pin)
#ifdef IR_SENSOR
static PinName const monitor_tx = P0_4;
static PinName const monitor_rx = P0_0;
//static PinName const monitor_tx = USBTX;
//static PinName const monitor_rx = USBRX;

static PinName const write_rx = P0_0;
static PinName const write_tx = P0_4;
static PinName const write_reset = P0_5;
static PinName const write_isp = P0_12;

static PinName const SPI_mosi = P0_27;
static PinName const SPI_miso = P0_16;
static PinName const SPI_sclk = P0_11;
static PinName const SPI_ss_ir = P0_10;

static PinName const din = P0_24;
static PinName const dout = P0_25;
static PinName const clk = P0_15;
static PinName const cs3 = P0_6;
static PinName const cs2 = P0_7;
static PinName const cs1 = P0_1;
static PinName const ir_vcc = P0_26;

Serial pc(monitor_tx, monitor_rx);
SPISlave nucleo(SPI_mosi, SPI_miso, SPI_sclk, SPI_ss_ir);
InterruptIn call(SPI_ss_ir);
SPI ir(din, dout, clk);
DigitalOut cs[IC_NUM] = {cs1, cs2, cs3};
PwmOut supply(ir_vcc);
#endif /*IR_SENSOR*/

#endif /*_MAIN_H_*/