#include "mbed.h"
#include "txrx.h"
#include "def.h"

#include "extern.h"

void cls() {
    for(int i=0;i<DATA_NUM;i++) INdata[i]=0;
}
void TX(void){//送信バッファ空き割り込み用関数
    
    static uint8_t Tx=DATA_NUM, i;
    static uint8_t TXdata[DATA_NUM]={TX_KEYCODE};
    static uint8_t TXcheckcode=0;
    
    if(Tx >= DATA_NUM){
        
        TXdata[KEY] = TX_KEYCODE;//Hello.
        
        TXdata[1] = EXdata[1];
        TXdata[2] = EXdata[2];
        TXdata[3] = EXdata[3];
        TXdata[4] = EXdata[4];
        TXdata[5] = EXdata[5];
        TXdata[6] = EXdata[6];
        TXdata[7] = EXdata[7];
        TXdata[8] = EXdata[8];
        //送信するデータ = メインで処理されたデータ
        
        for(i=KEY+1, TXcheckcode=0; i<CHECK; i++){//CHECKCODEの生成
            TXcheckcode ^= TXdata[i];
        }
        
        TXdata[CHECK] = TXcheckcode;//Good bye.
        Tx=0;//配列をリセット
        
    }
    RN42.putc(TXdata[Tx]);//データを送信する
    Tx++;//配列を入れ替える
    
}
void RX(void){//受信割り込み用関数

    static uint8_t Rx=0, i;
    static uint8_t RXdata[DATA_NUM]={RX_KEYCODE};
    static uint8_t RXcheckcode=0;
    
    RXdata[Rx] = RN42.getc();//データを受け取る
    
    if(RXdata[KEY]==RX_KEYCODE){//KEYCODEが一致したら配列を入れ替える
        Rx++;
    }
    
    if(Rx==CHECK){//CHECKCODEの生成
        for(i=KEY+1, RXcheckcode=0; i<CHECK; i++){
            RXcheckcode ^= RXdata[i];
        }
    }
    
    if(Rx >= DATA_NUM){
        if(RXdata[CHECK]==RXcheckcode){//CHECKCODEが合致したらデータを適用する
            
            Stp.attach(&cls, .5);
            INdata[1] = RXdata[1];
            INdata[2] = RXdata[2];
            INdata[3] = RXdata[3];
            INdata[4] = RXdata[4];
            INdata[5] = RXdata[5];
            INdata[6] = RXdata[6];
            INdata[7] = RXdata[7];
            INdata[8] = RXdata[8];
            //メインで処理されるデータ = 受け取ったデータ
            
        }
        Rx=0;//配列をリセット
    }
    
}
