#include "mbed.h"
#include "extern.h"

void Command(void){
    uint8_t SwState,x=0,y=0, z;
    uint8_t i;
    
    sys.jump_flag=JUMP_TAG_MAX;
    LcdPrint(&x,&y);
    while(1){
        SwState = ReadSw();
        if(SwState == NONE){
            if(x!=0){
                z = item[y].CommandFunction(x);
                if(z==1){
                    x=0;
                    //jump
                    if(sys.jump_flag!=JUMP_TAG_MAX){
                        for(i=0; i<STATE_NUM_Y; i++){
                            if(sys.jump_flag==item[i].tag_num) break;
                        }
                        if(i<STATE_NUM_Y){
                            y = i;
                            y %= STATE_NUM_Y;
                        }
                        sys.jump_flag=JUMP_TAG_MAX;
                    }
                    LcdPrint(&x,&y);
                }
                //Z==1...Once
                //Z==0...Endless
            }
            
            continue;
        }
        if(SwState == UP){
            y += -1 + STATE_NUM_Y;
            y %= STATE_NUM_Y;
            x=0;
        }
        if(SwState == DOWN){
            y++;
            y %= STATE_NUM_Y;
            x=0;
        }
        if(SwState == RIGHT){
            if(item[y].str_num<=1) x=0;
            else x++;
            x %= item[y].str_num;
        }
        if(SwState == LEFT){
            x=0;
        }
        if(x==0){
            X_ZERO_Function(&x,&y);
        }
        else{
            X_NZERO_Function(&x,&y);
        }
        LcdPrint(&x,&y);
    }
}
uint8_t X_ZERO_Function(uint8_t *x, uint8_t *y){
    uint8_t i;
    if(sys.jump_flag!=JUMP_TAG_MAX){//jump
        for(i=0; i<STATE_NUM_Y; i++){
            if(sys.jump_flag==item[i].tag_num) break;
        }
        if(i<STATE_NUM_Y){
            *y = i;
            *y %= STATE_NUM_Y;
        }
        sys.jump_flag=JUMP_TAG_MAX;
    }
    
    ReadCmps();
    //cmps_set.CmpsInitialValue = cmps_set.cmps;
    wait_ms(10);
    cmps_set.CmpsDiff = REFERENCE - cmps_set.cmps;
    cmps_set.FrontDeg=0;
    
    LineKeeper=LINE_FREE;//line
    return 0;
}
uint8_t X_NZERO_Function(uint8_t *x, uint8_t *y){
    LineKeeper=LINE_FIX;//line
    return 0;
}
uint8_t LcdPrint(uint8_t *x, uint8_t *y){
    Lcd.cls();
    Lcd.locate(0, 0);
    Lcd.print(item[*y].LcdStr[0]);
    Lcd.locate(7, 0);
    Lcd.print(">");
    Lcd.locate(9, 0);
    if(*x!=0) Lcd.print(item[*y].LcdStr[*x]);
    return 0;
}
