#ifndef _COMMAND_CONFIG_H_
#define _COMMAND_CONFIG_H_

#include "mbed.h"
#include "extern.h"

const CommandItem static item[STATE_NUM_Y]={
    {{"Start_","Active","______","______"}, 2, Start,               START},
    {{"TrnSrt","Active","______","______"}, 2, TurnAndStart,        TURN_AND_START},
    {{"Ir____","IrSpot","IrNote","IrPstn"}, 4, GetIr,               GET_IR},
    {{"Sens0_","LnABC_","PING__","BallAn"}, 4, GetSns0,             GET_SNS0},
    {{"Cmps__","cmps__","CpsRst","______"}, 3, RwPid,         RW_PID},
    {{"ClbTrn","Tuning","______","______"}, 2, CalibrationTurn,    CALIBRATION_TURN},
    {{"ClbEoE","EntExi","______","______"}, 3, CalibrationEnterOrExit,     CALIBRATION_ENTER_OR_EXIT},
    {{"PowUP_","NEXT__","CHANGE","______"}, 3, SetPowerDown,           SET_POWER_DOWN},
    {{"PowDWN","NEXT__","CHANGE","______"}, 3, SetPowerUp,           SET_POWER_UP},
    {{"Reset_","ByeBye","______","______"}, 2, SoftReset,           SOFT_RESET},
    {{"StrUP_","NEXT__","CHANGE","______"}, 3, SetStrategyDown,           SET_STRATEGY_DOWN},
    {{"StrDWN","NEXT__","CHANGE","______"}, 3, SetStrategyUp,           SET_STRATEGY_UP},
    {{"Kicker","DRIVE_","______","______"}, 2, DriveKicker,           DRIVE_KICKER},
    {{"Dribbl","DRIVE_","______","______"}, 2, DriveDribblerAndKicker,DRIVE_DRIBBLER_AND_KICKER},
    {{"Start2","Active","______","______"}, 2, Start2,              START2},
    {{"None__","Strgy_","Power_","SftRst"}, 4, ZeroFunction,        ZERO_FUNCTION},
    
    //char LcdStr[STATE_NUM_X][BUFSIZE];
    //uint8_t str_num;
    //uint8_t (*CommandFunction)(uint8_t x);
    //uint16_t tag_num;
};

#endif /*_COMMAND_CONFIG_H_*/