#ifndef _DEF_H_
#define _DEF_H_

//red or green
#define RED_CAT//jj
//#define GREEN_CAT//lily

//BT(BlueTooth)
#define DATA_NUM 8+2//2byte→KEYCODE（拝啓）とCHECKCODE（敬具） 8byte→やりとりするデータ
#define TX_KEYCODE 0xAA//あちらのKEYCODE
#define RX_KEYCODE 0xAA//こちらのKEYCODE
#define KEY 0//KEYCODEは配列の最初
#define CHECK DATA_NUM-1//CHECKCODEは配列の最後


//Switch 入力値
#define NONE    0
#define UP      1
#define DOWN    2
#define RIGHT   3
#define LEFT    4

//Lcd 設定値
#define LCD_COLUMN_NUM 0x11
#define BUFSIZE 7
#define STATE_NUM_X 0x08
#define STATE_NUM_Y 0x10

#define JUMP_TAG_MAX 0xFFFF
//tag
#define ZERO_FUNCTION       0
#define START               1
#define GET_IR              2
#define GET_SNS0            3
#define GET_PID_VALUE       4
#define CALIBRATION_ENTER   5
#define CALIBRATION_EXIT    6
#define FRONT_RESET         7
#define SET_POWER1          8
#define SET_POWER2          9
#define SOFT_RESET          10
#define SET_STRATEGY1       11
#define SET_STRATEGY2       12
#define SET_STRATEGY3       13
#define SET_STRATEGY4       14
#define START2              15

#define SET_POWER_DOWN      16
#define SET_POWER_UP        17
#define SET_STRATEGY_DOWN   18
#define SET_STRATEGY_UP     19

#define DRIVE_KICKER 20
#define DRIVE_DRIBBLER_AND_KICKER 21

#define CALIBRATION_TURN 22
#define RW_PID 23

#define TURN_AND_START 24
#define CALIBRATION_ENTER_OR_EXIT 25

typedef struct {//for command
    char LcdStr[STATE_NUM_X][BUFSIZE];
    uint8_t str_num;
    uint8_t (*CommandFunction)(uint8_t x);
    uint16_t tag_num;
} CommandItem;


//tag
#define MODE_ATTACK0 0
#define MODE_ATTACK1 1
#define MODE_ATTACK2 2
#define MODE_ATTACK3 3
#define MODE_ATTACK4 4
#define MODE_ATTACK5 5

#define MODE_DEBUG0 6
#define MODE_DEBUG1 7
#define MODE_DEBUG2 8
#define MODE_DEBUG3 9
#define MODE_DEBUG4 10
#define MODE_DEBUG5 11

typedef struct {//for active
    char LcdStr[LCD_COLUMN_NUM];
    void (*ActiveFunction)(void);
    uint16_t tag_num;
} ActiveItem;

//繰り返し割り込み
#define DUTY_NUM 1

#define DUTY_SW     0
#define DUTY_GYRO   1
#define DUTY_PING   2
#define DUTY_COLOR  3
#define DUTY_MOUSE  4

/*PID処理*/
#define RATE    0.052//52
#define PID_BIAS    0.0//1.0
#define REFERENCE   180.0
#define MINIMUM     0.0
#define MAXIMUM     359.9
#define P_GAIN  1.3//1.25//0.8    //0.78   
#define I_GAIN  0.0     //0.0
#define D_GAIN  0.01//0.01  //0.009
#define OUT_LIMIT   30.0
#define MAX_POW     100
#define MIN_POW     -100
#define PID_CYCLE   0.05   //s

#define PID_OUT_MIN 5

//hmc
#define HMC_RUN 1
#define HMC_RST 0

//ir 
//ir_pow_old
#define IR_X 0
#define IR_Y 1
//ir_pow
#define IR_X_DIR    0
#define IR_Y_DIR    1
#define IR_X_TURN   2
#define IR_Y_TURN   3

#define IR_SHORT 0
#define IR_LONG 1

#define X_AXIS 0
#define Y_AXIS 1


#define DIS_0 0x0//low_value
#define DIS_1 0x1
#define DIS_2 0x2
#define DIS_3 0x3
#define DIS_4 0x4
#define DIS_5 0x5
#define DIS_6 0x6
#define DIS_7 0x7//high_value

//ping
#define L_PING 1
#define R_PING 0
#define F_PING 2
#define B_PING 3

#define X_PING 0
#define Y_PING 1

//0,1...main
//2,3...debug board

//line
#define LINE_EMPTY 0xFF

#define A_SPOT 0
#define B_SPOT 1
#define C_SPOT 2
#define AB_SPOT 3

#define LINE_RF 5
#define LINE_DELAY_1 0.5//1.0
#define LINE_DELAY_2 0.125//0.5//.25
#define LINE_DELAY_3 0.125//.25

#define LINE_REPEAT 1

#define L_LINE 1
#define R_LINE 0
#define F_LINE 2
#define B_LINE 3

#define X_LINE 0
#define Y_LINE 1

#define LINE_INSIDE 0
#define LINE_OUTSIDE 1

//hard error

#ifdef RED_CAT
#define LINE_FIX 0x0
#define LINE_FREE 0x7

//右後左ド
#define MD_1CH (1)
#define MD_2CH (1)
#define MD_3CH (1)
#define MD_4CH (-1)
#endif /*RED_CAT*/

#ifdef GREEN_CAT
#define LINE_FIX 0x7
#define LINE_FREE 0x0

//右後左ド
#define MD_1CH (1)
#define MD_2CH (1)
#define MD_3CH (-1)
#define MD_4CH (-1)
#endif /*GREEN_CAT*/


//思考パターン
#define STRATEGY_NUM 12

//計算
#define ROUND(x) ((x > 0) ? (x + 0.5) : (x - 0.5))//x...整数
#define PI  3.14159265358979323846
#define DEG2RAD(deg)  (PI*(deg)/180.0)
#define RAD2DEG(rad)  (180.0(rad)/PI)

//データ
typedef struct {
    //cmps&pid
    double cmps, CmpsInitialValue, CmpsInitialValue2, CmpsInitialValue0, CmpsDiff;//0<x<360
    int16_t FrontDeg, AtkDeg, HoldDeg, GoalDeg;
    //正．．．右回転
    //負．．．左回転
    double InputPID;//<<gyrosensor
    int16_t OutputPID;//>>motor
} CompassVal;
typedef struct {
    //ping
    uint8_t ping[4];
    //line
    uint8_t lineSpot[3];
    uint8_t lnFlag[3];
    uint8_t NonWall[4];
    uint8_t NearWall[2];
    uint8_t ReturnDir[2];
    
    uint8_t lnHold;
    uint8_t lnRaw;
    uint8_t lnRawMemory[3];
    uint8_t lnRawOrder[3];//first_second_third
    uint8_t lnRawOrderLog1[3];//first_second_third
    uint8_t lnRawOrderLog2[3];//first_second_third
    uint8_t lnRawRise[3];
    uint8_t lnRawReturn;
    uint8_t lnRawLastRise;
    uint8_t lnStop[2];
    //uint8_t lnStay[2];
    uint8_t lnStay[2];
    uint8_t lnStayNow[2];
    uint8_t lnCorner[4];
    uint8_t lnRepeat;
    uint8_t FieldSpot;//0...inside,1...outside
    uint8_t lnOrder[3];//first_second_third
    
    uint8_t lnState;
    /*uint8_t LineFlag[3];
    uint8_t LinePriority[3];
    uint8_t LineBind[3];*/
    //ir(spi)
    uint8_t irKey;//2bit
    uint8_t irValPhase[2];//3*2bit
    uint8_t irDif[2];//3bit
    uint8_t irPosition;//5bit
    
    uint8_t irSpot[2];//4*2bit//old
    //ir(playing)
    uint8_t irNotice;
    uint8_t irLastNotice;
    uint8_t irStayNotice;
    uint8_t irLastPosition;
    //ball
    uint8_t ball;
} SensorVal;
typedef struct {
    //system,flag
    uint8_t strategy;
    uint16_t jump_flag;//0<=x<=JUMP_TAG_NUM
    uint8_t stopflag;
    uint8_t KickOffFlag;
    uint8_t DribbleFlag;
    uint8_t KickStopFlag;
    uint8_t TurnStopFlag;
    
    uint8_t BallHoldJudgeFlag;
    uint8_t BallHoldFlag;
    
    uint8_t BackHomeFlag;
    uint8_t HomeStayFlag[2];
    uint8_t TurnStartFlag;
    uint8_t MotorFlag;
    uint8_t InfoFlag;
    //uint8_t PidFlag;
    uint8_t DefenceFlag;
    //blind//on...1/off...0
    uint8_t IrBlind;
    uint8_t LineBlind;
    uint8_t PingBlind;
    
    uint8_t DriBlind;
    uint8_t DriMotorBlind;
    uint8_t TurnAtkBlind;
    uint8_t TurnDriBlind;
    uint8_t TurnHoldBlind;
    uint8_t KickBlind;
    uint8_t HomeBlind;
    
    //motor 
    uint8_t pow_num;
    uint8_t s_pow;
    uint8_t m_pow;
    uint8_t l_pow;
    uint8_t dri_pow;
    uint8_t ir_pow_table;
} SystemVal;

#endif