#include "mbed.h"
#include "extern.h"


uint8_t _samples[4]={0};
uint8_t _output[4]={0};
uint8_t _output_last[4]={0};
uint8_t _rising_flag[4]={0};

void Sw_sample(void) {
    int i;
    for(i=0; i<4; i++){
        _output_last[i] = _output[i];
        _output[i] = Sw[i].read();
        if (!_output[i] && _output_last[i])
        {
            _rising_flag[i]++;
        }
    }
    //pc.printf("food%d\r\n",_output_last[0]);
}
// return number of rising edges
uint8_t Sw_count(uint8_t pin) {
    //pin...from 0 to 3
    if(pin>=4) return 0;
     uint8_t return_value = _rising_flag[pin]; 
     _rising_flag[pin] = 0;
     return(return_value);
 }
// return the debounced status
uint8_t ReadSw(void){
/******
 *return : sw_state
 *スイッチを押したときの動作はdef.hを参照
 *チャタリング防止ライブラリ採用式
 *同時押しは判別されない
 *****/
    uint8_t i,result;
    for(i=result=0; i<4; i++){
        if(Sw_count(i) > 0){
            result = i+1;
        }
    }
    return result;
}
uint8_t CountSw(uint8_t pin){
/******
 *return : sw_state
 *スイッチを押したときの動作はdef.hを参照
 *チャタリング防止ライブラリ採用式
 *同時押しは判別されない
 *****/
    return (Sw_count(pin) > 0);
}