#ifndef _MAIN_H_
#define _MAIN_H_

#include "def.h"

//PinConfig

//SDカード管理用(20pin)
#ifdef SD_CARD

static PinName const monitor_tx = P0_4;
static PinName const monitor_rx = P0_0;

static PinName const write_RXD = P0_0;
static PinName const write_TXD = P0_4;
static PinName const write_RESET = P0_5;
static PinName const write_ISP = P0_12;

static PinName const SPI_MOSI = P0_23;
static PinName const SPI_MISO = P0_17;
static PinName const SPI_SCLK = P0_13;
static PinName const SPI_CS = P0_0;

static PinName const SD_MISO = P0_1;
static PinName const SD_MOSI = P0_10;
static PinName const SD_SCK = P0_15;
static PinName const SD_CS = P0_11;
static PinName const SD_SW = P0_14;

Serial pc(monitor_tx, monitor_rx);
SPISlave nucleo(SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS);
SDFileSystem sd(SD_MOSI, SD_MISO, SD_SCK, SD_CS, "sd");
DigitalIn SdSwitch(SD_SW);
#endif /*SD_CARD*/

//超音波用(20pin)
#ifdef ULTRA_SONIC

static PinName const monitor_tx = P0_4;
static PinName const monitor_rx = P0_0;

static PinName const write_rx = P0_0;
static PinName const write_tx = P0_4;
static PinName const write_reset = P0_5;
static PinName const write_isp = P0_12;

static PinName const SPI_mosi = P0_10;
static PinName const SPI_miso = P0_11;
static PinName const SPI_slck = P0_1;
static PinName const SPI_ss_sonic = P0_15;

static PinName const Sonic1_echo = P0_23;
static PinName const Sonic2_echo = P0_17;

static PinName const led_umr1 = P0_14;
static PinName const led_umr2 = P0_13;

Serial pc(monitor_tx, monitor_rx);
SPISlave nucleo(SPI_mosi, SPI_miso, SPI_slck, SPI_ss_sonic);
InterruptIn call(SPI_ss_sonic);
Ping rear(Sonic1_echo);
Ping front(Sonic2_echo);
DigitalOut led[2]={led_umr1, led_umr2};

#endif /*ULTRA_SONIC*/

//カラーセンサ用(33pin?)
#ifdef COLOR_SENSOR
static PinName const TX_PIN = dp10;
static PinName const RX_PIN = dp11;
Serial pc(TX_PIN, RX_PIN);


static PinName const COLOR00 = dp23;
static PinName const COLOR01 = dp22;
static PinName const COLOR02 = dp21;

static PinName const COLOR10 = dp23;
static PinName const COLOR11 = dp22;
static PinName const COLOR12 = dp21;

static PinName const COLOR20 = dp23;
static PinName const COLOR21 = dp22;
static PinName const COLOR22 = dp21;
AnalogIn ColorSensor[SENSOR_X_COLOR] = {COLOR00, COLOR01, COLOR02, COLOR10, COLOR11, COLOR12, COLOR20, COLOR21, COLOR22};

static PinName const MOSI = dp15;
static PinName const MISO = dp16;
static PinName const SCLK = dp17;
static PinName const SSEL = dp18;
SPISlave nucleo(MOSI, MISO, SCLK, SSEL);
#endif /*COLOR_SENSOR*/

//IRセンサー用(33pin)
#ifdef IR_SENSOR
static PinName const monitor_tx = P0_4;
static PinName const monitor_rx = P0_0;
//static PinName const monitor_tx = USBTX;
//static PinName const monitor_rx = USBRX;

static PinName const write_rx = P0_0;
static PinName const write_tx = P0_4;
static PinName const write_reset = P0_5;
static PinName const write_isp = P0_12;

static PinName const SPI_mosi = P0_27;
static PinName const SPI_miso = P0_16;
static PinName const SPI_sclk = P0_11;
static PinName const SPI_ss_ir = P0_10;

static PinName const din = P0_24;
static PinName const dout = P0_25;
static PinName const clk = P0_15;
static PinName const cs3 = P0_6;
static PinName const cs2 = P0_7;
static PinName const cs1 = P0_1;
static PinName const ir_vcc = P0_26;

Serial pc(monitor_tx, monitor_rx);
SPISlave nucleo(SPI_mosi, SPI_miso, SPI_sclk, SPI_ss_ir);
InterruptIn call(SPI_ss_ir);
SPI ir(din, dout, clk);
DigitalOut cs[IC_NUM] = {cs1, cs2, cs3};
PwmOut supply(ir_vcc);
#endif /*IR_SENSOR*/

#endif /*_MAIN_H_*/