#ifndef _EXTERN_H_
#define _EXTERN_H_

#include "def.h"

/*追加ライブラリ*/
#include "SDFileSystem.h"
#include "Ping.h"

#include "format.h"
/*クラス,ピン宣言等*/
#ifdef SD_CARD
extern Serial pc;
extern SPISlave nucleo;
extern SDFileSystem sd;
extern DigitalIn SdSwitch;
#endif /*SD_CARD*/

#ifdef ULTRA_SONIC
extern Serial pc;
extern SPISlave nucleo;
extern InterruptIn call;
extern Ping rear;
extern Ping front;
extern DigitalOut led[2];
#endif /*ULTRA_SONIC*/

#ifdef COLOR_SENSOR
extern Serial pc;
extern AnalogIn ColorSensor[];
extern SPISlave nucleo;
#endif /*COLOR_SENSOR*/

#ifdef IR_SENSOR
extern Serial pc;
extern SPISlave nucleo;
extern InterruptIn call;
extern SPI ir;
extern DigitalOut cs[];
extern PwmOut supply;
#endif /*IR_SENSOR*/

#endif /*_EXTERN_H_*/