#include "mbed.h" // mbed library
#include "MMA7660.h" // Accelerometer library
#include "GPS.h" // GPS library
#include "CMPS03.h" // Compass library
#include "C12832_lcd.h" // LCD screen library
#include "MSCFileSystem.h"
#define FSNAME "USB"
#define LIM 300
 
GPS gps(p9, p10); // GPS Connection
CMPS03 compass(p28, p27, CMPS03_DEFAULT_I2C_ADDRESS); // Compass connection
MMA7660 MMA(p28, p27); // Accelerometer connection
C12832_LCD lcd;
Serial pc(USBTX, USBRX);
 
// Declarations
float ax, ay, az;
DigitalOut connectionLed(LED1);
MSCFileSystem msc("USB"); // Mount USB stick under the name "USB"
 
int main()
{
    if (MMA.testConnection())
        connectionLed = 1; // Checking MMA connected correctly
   
    FILE *Accel = fopen("/USB/Accelerometer.csv", "w"); // Opens text file for Accelerometer                
    FILE *GPS = fopen("/USB/GPS.csv", "w"); // Opens text file for GPS                      
    FILE *Comp = fopen("/USB/Compass.csv", "w"); // Opens text file for Compass   
    
    int i;
    float bearing;
    
    while(i < LIM)
    {
        //Accelerometer
        Accel = fopen("/USB/Accelerometer.csv", "a");
        ax=MMA.x();
        ay=MMA.y();
        az=MMA.z();
        fprintf(Accel,"%f, %f, %f\r\n",ax,ay,az);
        lcd.locate(1,21);
        lcd.printf("Accel: %.2f, %.2f, %.2f", ax, ay, az);
                
        //GPS
        GPS = fopen("/USB/GPS.csv", "a");
        if (gps.sample())
        {
            fprintf(GPS, "%f, %f, %.1f\r\n", gps.latitude, gps.longitude, gps.rtime);
            lcd.locate(1,1);
            lcd.printf("GPS: %.4f, %.4f, %f", gps.latitude, gps.longitude, gps.rtime);
        }       
        else // For no signal
        {
            fprintf(GPS, "No Lock!\r\n");
            lcd.locate(1,1);
            lcd.printf("GPS: No Lock!");
        }
        
        // Compass
        Comp = fopen("/USB/Compass.csv", "a");
        lcd.locate(1,11);
        bearing = (compass.readBearing()/10) - 150;    // (150 = predetermined offset for magnetic North)
        if (bearing < 0)
        {
            bearing = 360 + bearing;
        }
        fprintf(Comp, "%.2f\r\n", bearing);
        lcd.printf("Bearing: %.2f, \n", bearing);
        
        i++;
        fclose(Accel);
        fclose(GPS);
        fclose(Comp);
    }
}  