/*
* うなりを生成する
*/
#include "sinc.h"

#define M_PI 3.141592653589793

sinc::sinc()
{
    
}

void sinc::init()
{
    generate();
}

void sinc::generate()
{
    //int    fre_1 = 39750;
    //int    fre_2 = 40250;
    int    fre_1 = 39750;
    int    fre_2 = 40250;
    
    double changeToLSB   = 4096 / 3.3;                    // 1LSB = 0.80566mV (12bit)
    
    for(int i = 0; i < BUFFER_SIZE; i++) {
        double ome_1 = 2 * M_PI * fre_1 * (i + BUFFER_SIZE)/(BUFFER_SIZE*1000/2);  // omega_1 = 2*pi*f_1
        double ome_2 = 2 * M_PI * fre_2 * (i + BUFFER_SIZE)/(BUFFER_SIZE*1000/2);  // omega_2 = 2*pi*f_2
        // 0 ~ 4095
        buffer[i] = (uint16_t)(changeToLSB * (AMPLITUDE * (sin((ome_1 + M_PI)) + sin(ome_2)) + OFFSET));
    }
}