/*
** 2018/07/24
** 受信プログラム
*/

#include "mbed.h"
#include "Adc.h"
#include "PhaseMethod.h"
#include "SD.h"
#include "Thermometer.h"

Adc         gAdc;
PhaseMethod gPhaseMethod;
SD          gSD;
Thermometer gThermometer;

/* setting */
Serial     pc(USBTX, USBRX);
DigitalIn  btn(USER_BUTTON);  // User button
DigitalOut startPin(PC_7);

void user_system_create()
{
    gAdc.init();
    gPhaseMethod.init(&gAdc, &gThermometer);
    gSD.init();
}

void start()
{
    while(btn);
    startPin = 1;
}

/* main */
int main()
{
    pc.printf("start\n");
    /* init */
    user_system_create();

    /* スタート */
    start();

    /* ADC */
    gAdc.read(gAdc.ADCVal, sizeof(gAdc.ADCVal));

    /* 位相一致法 */
    gPhaseMethod.calculation();

    /* 結果表示 */
    pc.printf("temp    :%.6lf \n",gThermometer.temp);
    pc.printf("Q1  :%.6lf\n",gPhaseMethod.Q1);
    pc.printf("Q2  :%.6lf\n",gPhaseMethod.Q2);
    pc.printf("I1  :%.6lf\n",gPhaseMethod.I1);
    pc.printf("I2  :%.6lf\n",gPhaseMethod.I2);
    pc.printf("txTime  :%.6lf s\n",gPhaseMethod.TxTime);
    pc.printf("epoch   :%.6lf s\n",gPhaseMethod.epoch);
    pc.printf("time    :%.6lf s\n",gPhaseMethod.arriveTime);
    pc.printf("distance:%.6lf mm\n",gPhaseMethod.distance);

    startPin = 0;
    
    /* SD保存 */
    for(int i = 0; i < ADC_TIMES; i++) {
        gSD.setData(i, gAdc.ADCVal[i]);
        gSD.write();
    }
    
    gSD.finish();
    pc.printf("finish\n");
    
}
