/*
* ログファイル
*/
#include "SD.h"

//Create an SDFileSystem object
SDFileSystem sd(D11, D12, D13, D10, "sd");

SD::SD()
{
          
}

void SD::init()
{   
    //Mount the filesystem
    sd.mount();
    
    updateLogNo();    
}

void SD::setData(int data1, int data2)
{
    Txdata1 = data1;
    Txdata2 = data2;
}

void SD::write()
{
    static bool isEntry = false;
   
    if (isEntry == false) {
        logFp = fopen(logFileName, "w");
        fprintf(logFp, "Time[ms],TxSinc[LSB]\n");
        isEntry = true;
    }
        
    fprintf(logFp,"%d,%d,\n",Txdata1,Txdata2);
}

void SD::updateLogNo()
{
    FILE* fp;
    char  buf[32];
    int   fileNo;
    
    if ((fp = fopen(LOG_NO_FILE_NAME, "r")) == NULL) {
        ; // エラー処理
    }
    
    fgets(buf, sizeof(buf), fp);
    sscanf(buf, "%d", &fileNo);
    fclose(fp);
    
    sprintf(logFileName, "/sd/logSync%03d.csv", fileNo);
    
    if ((fp = fopen(LOG_NO_FILE_NAME, "w")) == NULL) {
        ; // エラー処理
    }
    
    fprintf(fp, "%d\n", fileNo + 1);
    fclose(fp);
}

void SD::finish()
{
    fclose(logFp);
    sd.unmount();
}
