// F446RE ADC with DMA
// ADC read shifted to 16 bits, our readn is only 12 bits
// messy, TODO need ADC channel from pin number

#include "mbed.h"
#include "adc.h"
#include "SD.h"

adc gadc;
SD  gSD;

DigitalIn btn(USER_BUTTON);  // User button
PwmOut OSILO_PWM(PC_7);
Serial pc(USBTX, USBRX); // tx, rx

void user_system_create()
{
    gadc.init();
    gSD.init();

    // PWM出力の初期化処理 <PWM出力開始>
    OSILO_PWM.period_ms(1);     // PWM周波数は1kHz(周期:1ms)
    OSILO_PWM.write(0.5f);      // Duty比:50%
}

int main()
{
    /* init */
    user_system_create();

    pc.printf("PUSH USER BUTTON\n");
    while(btn); // Wait user button

    /* Start ADC with DMA */
    pc.printf("Start ADC\n");
    gadc.read(gadc.ADCVal, sizeof(gadc.ADCVal));

    for(int i = 0; i < ADC_TIMES; i++) {
        pc.printf("%d,%d\n",i,gadc.ADCVal[i]);
    }

    for(int i = 0; i < ADC_TIMES; i++) {
        gSD.setData(i, gadc.ADCVal[i]);
        gSD.write();
    }
    
    gSD.finish();
}
