#include "mbed.h"
#include "MPU6050_DMP6.h"
#include "HMC5883L.h"
#include "SDFileSystem.h"
#include "SkipperSv2.h"
#include "falfalla.h"

void MoveCansat(char g_landingcommand);

Timer t;

RawSerial raspi(PC_6,PC_7,115200); //uart6 raspi

/*通信用のpinは
  PA_3(UART2_Rx)   skipperウラ
  PA_12(UART6_Rx)  skipperオモテ USB端子より
  PB_7 (UART1_Rx)  skipperオモテ 6番目 TIM4_CH2
*/


int main() {
    t.start();
    if(t>7){ 
        while(1){
            MoveCansat('F');
            wait(5);
            MoveCansat('S');
            wait(3);
            MoveCansat('R');
            wait(5);
            MoveCansat('S');
            wait(3);
            MoveCansat('L');
            wait(5);
            MoveCansat('S');
            wait(3);
            MoveCansat('B');
            wait(5);
            MoveCansat('S');
            wait(3);
        }
    }
      return 0;
}


void MoveCansat(char a)
{
    switch(a){
        case 'F': //MOVE_FORWARD
            raspi.printf("F\r\n");
            break;
            
        case 'R': //MOVE_RIGHT
            raspi.printf("R\r\n");
            break;
            
        case 'L': //MOVE_LEFT
            raspi.printf("L\r\n");
            break;
            
        case 'S': //STOP  
            raspi.printf("S\r\n");
            break;
        
        case 'B': //MOVE_BACK
            raspi.printf("B\r\n");
            break;
    }
    return;
}




/*void getSF_Serial_jevois(){
    
    //pc.printf("jevois\r\n");


    static char SFbuf[16]={'Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q'};
    
    static int bufcounter=0;
        
       

    if(pc.readable()) {    // 受信確認
        
        SFbuf[bufcounter] = pc.getc();    // 1文字取り出し
        if(SFbuf[0]!='S'){
             //pc.printf("x");
             return;
        }  
        
                
        
        //pc.printf("%c",SFbuf[bufcounter]);
        
        if(SFbuf[0]=='S' && bufcounter<5)bufcounter++;
            
        if(bufcounter==5 && SFbuf[4]=='F'){
                
            g_landingcommand = SFbuf[1];
            wait_ms(31);//信号が速すぎることによる割り込み防止
            //pc.printf("%c",g_landingcommand);
            //wait_ms(20);
            //if(g_landingcommand=='Y')g_SerialTargetYAW = ConvertByteintoFloat(SFbuf[2], SFbuf[3]);
            bufcounter = 0;
            memset(SFbuf, 0, sizeof(SFbuf));
            NVIC_ClearPendingIRQ(USART2_IRQn);
            //pc.printf("command = %c, commandYAW = %f\r\n", g_landingcommand, g_SerialTargetYAW); 
        }
            
        else if(bufcounter>=5){
            //pc.printf("Communication Falsed.\r\n");
            memset(SFbuf, 0, sizeof(SFbuf));
            bufcounter = 0;
            NVIC_ClearPendingIRQ(USART2_IRQn);
        }
    }
                    

}


void getSF_Serial_pi(){
    
    //NVIC_DisableIRQ(USART2_IRQn);

    static char SFbuf[16]={'Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q'};
    
    static int bufcounter=0;
        
       

    if(pc2.readable()) {    // 受信確認
        
        SFbuf[bufcounter] = pc2.getc();    // 1文字取り出し
        if(SFbuf[0]!='S'){
             //pc.printf("x");
             return;
        }  
        
                
        
        //pc.printf("%c",SFbuf[bufcounter]);
        
        if(SFbuf[0]=='S'&&bufcounter<5)bufcounter++;
            
        if(bufcounter==5 && SFbuf[4]=='F'){
                
            g_landingcommand = SFbuf[1];
            wait_ms(31);//信号が速すぎることによる割り込み防止
            //pc.printf("%c",g_landingcommand);
            //wait_ms(20);
            //if(g_landingcommand=='Y')g_SerialTargetYAW = ConvertByteintoFloat(SFbuf[2], SFbuf[3]);
            bufcounter = 0;
            memset(SFbuf, 0, sizeof(SFbuf));
            NVIC_ClearPendingIRQ(USART2_IRQn);
            //pc.printf("command = %c, commandYAW = %f\r\n", g_landingcommand, g_SerialTargetYAW); 
        }
            
        else if(bufcounter>=5){
            //pc.printf("Communication Falsed.\r\n");
            memset(SFbuf, 0, sizeof(SFbuf));
            bufcounter = 0;
            NVIC_ClearPendingIRQ(USART2_IRQn);
        }
    }
    
    //NVIC_EnableIRQ(USART2_IRQn);
                    
}*/

