#include "mbed.h"
#include "MPU6050_DMP6.h"
#include "HMC5883L.h"
#include "SDFileSystem.h"
#include "SkipperSv2.h"
#include "falfalla.h"

//MPU_check用
#define PI 3.14159265358979

#define servo_NEUTRAL_R    1614
#define servo_NEUTRAL_L    1621
#define servo_slow_FORWARD_R    1560
#define servo_slow_FORWARD_L    1560
#define servo_low_FORWARD_R     1560   //RasPi速さ調節用 
#define servo_high_FORWARD_R    1860
#define servo_low_FORWARD_L     1560
#define servo_high_FORWARD_L    1860
#define servo_low_back_R        1360
#define servo_high_back_R       1160
#define servo_low_back_L        1360
#define servo_high_back_L       1160
#define turntable_NEUTRAL     1180 //カメラ台座のサーボ
#define matchspeed 1500 + 100 //カメラと方向を合わせるときの車輪の速度
#define focus_NEUTRAL  1455  //焦点合わせ用サーボ
#define camera_deg_A 1400   //カメラ角度調整
#define camera_deg_B 1800
#define pint_speed 25
#define pint_wait 3.5

#define MOVE_NEUTRAL    0
#define MOVE_FORWARD    1   
#define MOVE_LEFT       2
#define MOVE_RIGHT      3
#define MOVE_BACK       4
#define GOAL_FORWARD    5          //ゴール付近_ゆっくり
#define GOAL_LEFT       6
#define GOAL_RIGHT      7
#define MAX_FORWARD     8          //はやい_姿勢修正用
#define MAX_BACK        9

void getSF_Serial_jevois();
void getSF_Serial_pi();

//MPU_check用
void SensingMPU();

void MoveCansat(char g_landingcommand);
void setup();
void Init_sensors();
void DisplayClock();
void DebugPrint();
void SensingHMC();
void MoveCameraBoard();
void MatchPosition();
void FocusAdjust();

//sd設定
int GetParameter(FILE *fp, const char *paramName,char parameter[]);

int SetOptions(int *Servo_NEUTRAL_R,int *Servo_NEUTRAL_L,
            int *Servo_high_FORWARD_R,int *Servo_high_FORWARD_L,
            int *Servo_slow_FORWARD_R,int *Servo_slow_FORWARD_L,
            int *Turntable_NEUTRAL,int *Matchspeed,int *Focus_NEUTRAL,
            int *Camera_deg_A, int *Camera_deg_B,
            int *Pint_speed, float *Pint_wait
            );

static float nowAngle[3] = {0,0,0},nowAngle_HMC=0;
float FirstROLL = 0.0, FirstPITCH = 0.0 ,FirstYAW = 0.0,g_FirstYAW_HMC;

bool setupFlag = false;
bool CameraDegFlag = false;
bool jevoisFlag = true;

enum Angle{ROLL, PITCH, YAW};   //yaw:北を0とした絶対角度

Timer t;

SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");

RawSerial pc(PA_2,PA_3,115200); //uart2
//pa2:UART2_TX,pa3:UART2_RX
RawSerial pc2(PA_11,PA_12,115200); //uart1
//pb6:UART1_TX,pb7:UART1_RX

//PWM pin宣言
PwmOut servoR(PC_6);           //TIM3_CH1 車輪右
PwmOut servoL(PC_7);           //TIM3_CH2 車輪左
PwmOut servoTurnTable(PB_0);   //TIM3_CH3 カメラ台回転Servo
PwmOut servoCameradeg(PB_1);   //TIM3_CH4 カメラ角度調節Servo
PwmOut servoCameraPinto(PB_6); //TIM4_CH1 カメラピント合わせ
PwmOut servoCameramount(PA_6); //skipperウラ カメラマウント起動
PwmOut servoGetUP(PC_8);       //skipperウラ 起き上がり動作

/*通信用のpinは
  PA_3(UART2_Rx)   skipperウラ
  PA_12(UART6_Rx)  skipperオモテ USB端子より
  PB_7 (UART1_Rx)  skipperオモテ 6番目 TIM4_CH2
*/

/*超音波はRaspberryPiに積む*/

//外付けコンパス
HMC5883L compass(PB_9, PB_8);    //コンパスセンサー TIM4_CH3とCH4

char g_landingcommand='N';

//MPU_check用
MPU6050DMP6 mpu6050(PC_0,&pc);


int main() {
    
    //MPU_check
    setup();
    
    servoCameradeg.pulsewidth_us(camera_deg_A);
    
    // シリアル通信受信の割り込みイベント登録
    pc.attach(getSF_Serial_jevois, Serial::RxIrq);
    pc2.attach(getSF_Serial_pi, Serial::RxIrq);
    
    while(1) {
        if(jevoisFlag==true) NVIC_DisableIRQ(USART1_IRQn);
        else NVIC_DisableIRQ(USART2_IRQn);
        
        MoveCameraBoard();
        
        if(g_landingcommand!='N') MatchPosition();
        
        if(jevoisFlag==true) NVIC_DisableIRQ(USART1_IRQn);
        else NVIC_DisableIRQ(USART2_IRQn);
        
        MoveCansat(g_landingcommand); 
        wait_ms(23);
        
        if(jevoisFlag==true) NVIC_EnableIRQ(USART1_IRQn);
        else NVIC_EnableIRQ(USART2_IRQn);
        }
}


void MoveCansat(char g_landingcommand)
{
    //NVIC_DisableIRQ(USART1_IRQn);
    //NVIC_DisableIRQ(USART2_IRQn);
    switch(g_landingcommand){
        case 'N': //MOVE_NEUTRAL 
            servoR.pulsewidth_us(servo_NEUTRAL_R);
            servoL.pulsewidth_us(servo_NEUTRAL_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn);
            break;
            
        case 'Y': //MOVE_FORWARD
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
            
        case 'l': //MOVE_LEFT Low Speed
            servoR.pulsewidth_us(servo_low_FORWARD_R);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
        
        case 'L': //MOVE_LEFT High Speed
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
            
        case 'r': //MOVE_RIGHT Low Speed  
            servoL.pulsewidth_us(servo_low_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case 'R': //MOVE_RIGHT  High Speed
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
            
        case 'G': //GOAL_FORWARD
            servoR.pulsewidth_us(servo_slow_FORWARD_R);
            servoL.pulsewidth_us(servo_slow_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case '1': //MOVE_FORWARD Speed Level 1
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            wait(1);
            do{
            }while((nowAngle[PITCH]<20&&nowAngle[PITCH]>-20)&&(nowAngle[ROLL]<20&&nowAngle[ROLL]>-20));
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case '2': //MOVE_FORWARD Speed Level 2
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            wait(2);
            do{
            }while((nowAngle[PITCH]<20&&nowAngle[PITCH]>-20)&&(nowAngle[ROLL]<20&&nowAngle[ROLL]>-20));
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case '3': //MOVE_FORWARD Speed Level 3
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            wait(3);
            do{
            }while((nowAngle[PITCH]<20&&nowAngle[PITCH]>-20)&&(nowAngle[ROLL]<20&&nowAngle[ROLL]>-20));
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case '4': //MOVE_FORWARD Speed Level 4
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            wait(4);
            do{
            }while((nowAngle[PITCH]<20&&nowAngle[PITCH]>-20)&&(nowAngle[ROLL]<20&&nowAngle[ROLL]>-20));
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
            
        case '5': //MOVE_FORWARD Speed Level 5
            servoR.pulsewidth_us(servo_high_FORWARD_R);
            servoL.pulsewidth_us(servo_high_FORWARD_L);
            //NVIC_EnableIRQ(USART1_IRQn);
            wait(5);
            do{
            }while((nowAngle[PITCH]<20&&nowAngle[PITCH]>-20)&&(nowAngle[ROLL]<20&&nowAngle[ROLL]>-20));
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
            
        case 'M': //MatchPosition
            servoR.pulsewidth_us(matchspeed);
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case 'P': //jevoisからraspberry piへの切り替え
            jevoisFlag = false;
            //NVIC_EnableIRQ(USART2_IRQn); 
            break;
        
        case 'S':
            /*RasPiからの超音波判定(プログラムスタート部)*/
            break;
            
        default :
            //NVIC_EnableIRQ(USART1_IRQn);
            //NVIC_EnableIRQ(USART2_IRQn);  
            break;
     
    }
    
    return;
}

void MoveCameraBoard(){
    MoveCansat('N');
    g_landingcommand='N';
    servoTurnTable.pulsewidth_us(1800);
    wait_ms(600);
    servoTurnTable.pulsewidth_us(turntable_NEUTRAL);
    if(jevoisFlag == true) FocusAdjust();
    else wait(1);
    
    if(g_landingcommand!='N') return;
    if(!CameraDegFlag){
        for(int i=0; i<camera_deg_B-camera_deg_A;i=i+10){
            servoCameradeg.pulsewidth_us(camera_deg_A+10);
            wait_ms(20);
            }
        CameraDegFlag=!CameraDegFlag;
        }else{
            for(int i=0; i<camera_deg_B-camera_deg_A;i=i+10){
            servoCameradeg.pulsewidth_us(camera_deg_A-10);
            }
        CameraDegFlag = !CameraDegFlag;
    }
        
    if(jevoisFlag == true) FocusAdjust();
    else wait(1);
    
    return;
}

void MatchPosition(){
    SensingMPU();
    SensingHMC();
    DebugPrint();
    
    while(nowAngle[YAW] <= nowAngle_HMC+5 && nowAngle[YAW] >= nowAngle_HMC-5){
        MoveCansat('M');
        SensingMPU();
    }
    return;
}

void FocusAdjust(){
    servoCameraPinto.pulsewidth_us(focus_NEUTRAL-200);
    //pc.printf("set\r\n");
    wait(1);
    
    servoCameraPinto.pulsewidth_us(focus_NEUTRAL+pint_speed);
    //pc.printf("check\r\n");
    wait(pint_wait);
    servoCameraPinto.pulsewidth_us(focus_NEUTRAL);
      
  return;      
}     

void getSF_Serial_jevois(){


    static char SFbuf[16]={'Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q'};
    
    static int bufcounter=0;
        
       

    if(pc.readable()) {    // 受信確認
        
        SFbuf[bufcounter] = pc.getc();    // 1文字取り出し
        if(SFbuf[0]!='S'){
             //pc.printf("x");
             return;
        }  
        
                
        
        //pc.printf("%c",SFbuf[bufcounter]);
        
        if(SFbuf[0]=='S' && bufcounter<5)bufcounter++;
            
        if(bufcounter==5 && SFbuf[4]=='F'){
                
            g_landingcommand = SFbuf[1];
            wait_ms(31);//信号が速すぎることによる割り込み防止
            //pc.printf("%c",g_landingcommand);
            //wait_ms(20);
            //if(g_landingcommand=='Y')g_SerialTargetYAW = ConvertByteintoFloat(SFbuf[2], SFbuf[3]);
            bufcounter = 0;
            memset(SFbuf, 0, sizeof(SFbuf));
            NVIC_ClearPendingIRQ(USART2_IRQn);
            //pc.printf("command = %c, commandYAW = %f\r\n", g_landingcommand, g_SerialTargetYAW); 
        }
            
        else if(bufcounter>=5){
            //pc.printf("Communication Falsed.\r\n");
            memset(SFbuf, 0, sizeof(SFbuf));
            bufcounter = 0;
            NVIC_ClearPendingIRQ(USART2_IRQn);
        }
    }
                    

}


void getSF_Serial_pi(){
    
    //NVIC_DisableIRQ(USART2_IRQn);

    static char SFbuf[16]={'Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q','Q'};
    
    static int bufcounter=0;
        
       

    if(pc2.readable()) {    // 受信確認
        
        SFbuf[bufcounter] = pc2.getc();    // 1文字取り出し
        if(SFbuf[0]!='S'){
             //pc.printf("x");
             return;
        }  
        
                
        
        //pc.printf("%c",SFbuf[bufcounter]);
        
        if(SFbuf[0]=='S'&&bufcounter<5)bufcounter++;
            
        if(bufcounter==5 && SFbuf[4]=='F'){
                
            g_landingcommand = SFbuf[1];
            wait_ms(31);//信号が速すぎることによる割り込み防止
            //pc.printf("%c",g_landingcommand);
            //wait_ms(20);
            //if(g_landingcommand=='Y')g_SerialTargetYAW = ConvertByteintoFloat(SFbuf[2], SFbuf[3]);
            bufcounter = 0;
            memset(SFbuf, 0, sizeof(SFbuf));
            NVIC_ClearPendingIRQ(USART2_IRQn);
            //pc.printf("command = %c, commandYAW = %f\r\n", g_landingcommand, g_SerialTargetYAW); 
        }
            
        else if(bufcounter>=5){
            //pc.printf("Communication Falsed.\r\n");
            memset(SFbuf, 0, sizeof(SFbuf));
            bufcounter = 0;
            NVIC_ClearPendingIRQ(USART2_IRQn);
        }
    }
    
    //NVIC_EnableIRQ(USART2_IRQn);
                    
}


void setup(){
     
    SetOptions(&Servo_NEUTRAL_R, &Servo_NEUTRAL_L,
               &Servo_high_FORWARD_R, &Servo_high_FORWARD_L,
               &Servo_slow_FORWARD_R,&Servo_slow_FORWARD_L,
               &Turntable_NEUTRAL,&Matchspeed,&Focus_NEUTRAL,
               &Camera_deg_A, &Camera_deg_B,
               &Pint_speed,&Pint_wait
               
               );
     
    Init_sensors();
    //switch2.rise(ResetTrim);
    
    //NVIC_SetPriority(USART1_IRQn,0);
    //NVIC_SetPriority(EXTI0_IRQn,1);
    //NVIC_SetPriority(TIM5_IRQn,2);
    //NVIC_SetPriority(EXTI9_5_IRQn,3);
    //NVIC_SetPriority(USART2_IRQn,4);
    
    NVIC_SetPriority(USART1_IRQn,0);//割り込み優先度
    NVIC_SetPriority(USART2_IRQn,1);
    
    DisplayClock();
    t.start();
    
    pc.printf("MPU calibration start\r\n");
    pc.printf("HMC calibration start\r\n");
    
    float offsetstart = t.read();
    while(t.read() - offsetstart < 26){
        SensingMPU();
        SensingHMC();
        for(uint8_t i=0; i<3; i++) pc.printf("%3.2f\t",nowAngle[i]);
        pc.printf("%3.2f\t",nowAngle_HMC);
        pc.printf("\r\n");
    }
    
    FirstROLL = nowAngle[ROLL];
    FirstPITCH = nowAngle[PITCH];
    nowAngle[ROLL] -=FirstROLL;
    nowAngle[PITCH] -=FirstPITCH;
    FirstYAW = nowAngle[YAW];
    nowAngle[YAW] -= FirstYAW;
    
    g_FirstYAW_HMC = nowAngle_HMC;
    nowAngle_HMC -=g_FirstYAW_HMC;
    if(nowAngle_HMC<0)nowAngle_HMC+=360;
    
    wait(0.2);
    
    pc.printf("All initialized\r\n");
    setupFlag=true;
}


void SensingMPU(){
    //static int16_t deltaT = 0, t_start = 0;
    //t_start = t.read_us();
    
    float rpy[3] = {0};
    static uint16_t count_changeRPY = 0;
    static bool flg_checkoutlier = false;
    NVIC_DisableIRQ(USART1_IRQn);
    NVIC_DisableIRQ(USART2_IRQn);
    NVIC_DisableIRQ(TIM5_IRQn);
    NVIC_DisableIRQ(EXTI0_IRQn);
    NVIC_DisableIRQ(EXTI9_5_IRQn);

    mpu6050.getRollPitchYaw_Skipper(rpy);
 
    NVIC_EnableIRQ(USART1_IRQn);
    NVIC_EnableIRQ(USART2_IRQn);
    NVIC_EnableIRQ(TIM5_IRQn);
    NVIC_EnableIRQ(EXTI0_IRQn);
    NVIC_EnableIRQ(EXTI9_5_IRQn);
    
    
    //外れ値対策
    for(uint8_t i=0; i<3; i++) rpy[i] *= 180.0f/PI;
    rpy[ROLL] -= FirstROLL;
    rpy[PITCH] -= FirstPITCH;
    if(!setupFlag){
        rpy[YAW] -= FirstYAW;
        }else{
        if(rpy[YAW] >= FirstYAW){
            rpy[YAW] -= FirstYAW;
            }else{
            rpy[YAW] += 360.0f;
            rpy[YAW] -= FirstYAW;
        }
    }
    
    for(uint8_t i=0; i<3; i++) {if(rpy[i] < nowAngle[i]-10 || rpy[i] > nowAngle[i]+10) {flg_checkoutlier = true;}}
    if(!flg_checkoutlier || count_changeRPY >= 2){
        for(uint8_t i=0; i<3; i++){
            nowAngle[i] = (rpy[i] + nowAngle[i])/2.0f;  //2つの移動平均
        }
        count_changeRPY = 0;
    }else   count_changeRPY++;
    flg_checkoutlier = false;
    
}


void Init_sensors(){
    if(mpu6050.setup() == -1){
        pc.printf("failed initialize\r\n");
    }
}


void DisplayClock(){
    pc.printf("System Clock = %d[MHz]\r\n", HAL_RCC_GetSysClockFreq()/1000000);
    pc.printf("HCLK Clock   = %d[MHz]\r\n", HAL_RCC_GetHCLKFreq()/1000000);
    pc.printf("PCLK1 Clock  = %d[MHz]\r\n", HAL_RCC_GetPCLK1Freq()/1000000);
    pc.printf("PCLK2 Clock  = %d[MHz]\r\n", HAL_RCC_GetPCLK2Freq()/1000000);
    pc.printf("\r\n");
}
    
void SensingHMC(){
    //static int16_t deltaT = 0, t_start = 0;
    //t_start = t.read_us();
    
    float rpy=0;
    static uint16_t count_changeRPY = 0;
    static bool flg_checkoutlier = false;
    NVIC_DisableIRQ(USART1_IRQn);
    NVIC_DisableIRQ(USART2_IRQn);
    NVIC_DisableIRQ(TIM5_IRQn);
    NVIC_DisableIRQ(EXTI0_IRQn);
    NVIC_DisableIRQ(EXTI9_5_IRQn);

    rpy= compass.getHeadingXYDeg(20,50);
 
    NVIC_EnableIRQ(USART1_IRQn);
    NVIC_EnableIRQ(USART2_IRQn);
    NVIC_EnableIRQ(TIM5_IRQn);
    NVIC_EnableIRQ(EXTI0_IRQn);
    NVIC_EnableIRQ(EXTI9_5_IRQn);
    
    
    //外れ値対策
    //rpy*= 180.0f/PI;
    if(!setupFlag){
        rpy -= g_FirstYAW_HMC;
        }else{
        if(rpy >= g_FirstYAW_HMC){
            rpy -= g_FirstYAW_HMC;
            }else{
            rpy += 360.0f;
            rpy -= g_FirstYAW_HMC;
        }
    }
    
    if(rpy < nowAngle_HMC-10 || rpy > nowAngle_HMC+10) {flg_checkoutlier = true;}
    if(!flg_checkoutlier || count_changeRPY >= 2){
        
        nowAngle_HMC = (rpy + nowAngle_HMC)/2.0f;  //2つの移動平均
        
        count_changeRPY = 0;
    }else   count_changeRPY++;
    flg_checkoutlier = false;
    
}

int SetOptions(int *Servo_NEUTRAL_R, int *Servo_NEUTRAL_L,
               int *Servo_high_FORWARD_R, int *Servo_high_FORWARD_L,
               int *Servo_slow_FORWARD_R,int *Servo_slow_FORWARD_L,
               int *Turntable_NEUTRAL,int *Matchspeed,int *Focus_NEUTRAL,
               int *Camera_deg_A, int *Camera_deg_B,
               int *Pint_speed, float *Pint_wait
               ){

    pc.printf("SDsetup start.\r\n");    
    
    FILE *fp;
    char parameter[20]; //文字列渡す用の配列
    int SDerrorcount = 0;  //取得できなかった数を返す
    const char *paramNames[] = { 
        "SERVO_NEUTRAL_R",
        "SERVO_NEUTRAL_L",
        "SERVO_HIGH_FORWARD_R",
        "SERVO_HIGH_FORWARD_L",
        "SERVO_SLOW_FORWARD_R",
        "SERVO_SLOW_FORWARD_L",
        "TURNTABLE_NEUTRAL",
        "MATCH_SPEED",
        "FOCUS_NEUTRAL",
        "CAMERA_DEG_A",
        "CAMERA_DEG_B",
        "PINT_SPEED",
        "PINT_WAIT"
    };

    fp = fopen("/sd/option.txt","r");
    
    if(fp != NULL){ //開けたら
        pc.printf("File was openned.\r\n");
        if(GetParameter(fp,paramNames[0],parameter)) *Servo_NEUTRAL_R = atof(parameter);
        else{                                        *Servo_NEUTRAL_R = servo_NEUTRAL_R;
                                                     SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[1],parameter)) *Servo_NEUTRAL_L = atof(parameter);
        else{                                        *Servo_NEUTRAL_L = servo_NEUTRAL_L;
                                                      SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[2],parameter)) *Servo_high_FORWARD_R = atof(parameter);
        else{                                        *Servo_high_FORWARD_R = servo_high_FORWARD_R;
                                                     SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[3],parameter)) *Servo_high_FORWARD_L = atof(parameter);
        else{                                        *Servo_high_FORWARD_L = servo_high_FORWARD_L;
                                                      SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[4],parameter)) *Servo_slow_FORWARD_R = atof(parameter);
        else{                                        *Servo_slow_FORWARD_R = servo_slow_FORWARD_R;
                                                      SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[5],parameter)) *Servo_slow_FORWARD_L = atof(parameter);
        else{                                        *Servo_slow_FORWARD_L = servo_slow_FORWARD_L;
                                                      SDerrorcount++;
        }
        
        if(GetParameter(fp,paramNames[6],parameter)) *Turntable_NEUTRAL = atof(parameter);
        else{                                         *Turntable_NEUTRAL = turntable_NEUTRAL;
                                                      SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[7],parameter)) *Matchspeed = atof(parameter);
        else{                                         *Matchspeed = matchspeed;
                                                      SDerrorcount++;
        }
        if(GetParameter(fp,paramNames[8],parameter)) *Focus_NEUTRAL = atof(parameter);
        else{                                         *Focus_NEUTRAL = focus_NEUTRAL;
                                                      SDerrorcount++;
        }
         if(GetParameter(fp,paramNames[9],parameter)) *Camera_deg_A = atof(parameter);
        else{                                         *Camera_deg_A = camera_deg_A;
                                                      SDerrorcount++;
        }
         if(GetParameter(fp,paramNames[10],parameter)) *Camera_deg_B = atof(parameter);
        else{                                         *Camera_deg_B = camera_deg_B;
                                                      SDerrorcount++;
        }
         if(GetParameter(fp,paramNames[11],parameter)) *Pint_speed = atof(parameter);
        else{                                         *Pint_speed = pint_speed;
                                                      SDerrorcount++;
        }
         if(GetParameter(fp,paramNames[12],parameter)) *Pint_wait = atof(parameter);
        else{                                         *Pint_wait = pint_wait;
                                                      SDerrorcount++;
        }
        
        fclose(fp);

    }else{  //ファイルがなかったら
        pc.printf("fp was null.\r\n");
        
        *Servo_NEUTRAL_R = servo_NEUTRAL_R;
        *Servo_NEUTRAL_L = servo_NEUTRAL_L;
        *Servo_high_FORWARD_R = servo_high_FORWARD_R;
        *Servo_high_FORWARD_L = servo_high_FORWARD_L;
        *Servo_slow_FORWARD_R = servo_slow_FORWARD_R;
        *Servo_slow_FORWARD_L = servo_slow_FORWARD_L;
        *Turntable_NEUTRAL = turntable_NEUTRAL;
        *Matchspeed = matchspeed;
        *Focus_NEUTRAL = focus_NEUTRAL;
        *Camera_deg_A = camera_deg_A;
        *Camera_deg_B = camera_deg_B;
        *Pint_speed = pint_speed;
        *Pint_wait = pint_wait;
        SDerrorcount = -1;
    }
    pc.printf("SDsetup finished.\r\n");
    if(SDerrorcount == 0)  pc.printf("setting option is success\r\n");
    else if(SDerrorcount == -1) pc.printf("ERROR 1. cannot open option\r\n");
    else if(SDerrorcount > 0)  pc.printf("ERROR 2. reading parameter is failed[%d]\r\n",SDerrorcount); 
    
    pc.printf("Servo_NEUTRAL_R = %d, Servo_NEUTRAL_L = %d\r\n", *Servo_NEUTRAL_R, *Servo_NEUTRAL_L);
    pc.printf("Servo_high_FORWARD_R = %d, Servo_high_FORWARD_L = %d\r\n", *Servo_high_FORWARD_R, *Servo_high_FORWARD_L);
    pc.printf("Servo_slow_FORWARD_R = %d, Servo_slow_FORWARD_L = %d\r\n", *Servo_slow_FORWARD_R, *Servo_slow_FORWARD_L);
    pc.printf("Turntable_NEUTRAL = %d, Matchspeed =  %d\r\n", *Turntable_NEUTRAL, *Matchspeed);
    pc.printf("Focus_NEUTRAL = %d\r\n", *Focus_NEUTRAL);
    pc.printf("Camera_deg_A = %d, Camera_deg_B =  %d\r\n", *Camera_deg_A, *Camera_deg_B);
    pc.printf("Pint_speed = %d, Pint_wait =  %f\r\n", *Pint_speed, *Pint_wait);
    
    return SDerrorcount;
}            

int GetParameter(FILE *fp, const char *paramName,char parameter[]){
    int i=0, j=0;
    int strmax = 200;
    char str[strmax];

    rewind(fp); //ファイル位置を先頭に
    while(1){
        if (fgets(str, strmax, fp) == NULL) {
            return 0;
        }
        if (!strncmp(str, paramName, strlen(paramName))) {
            while (str[i++] != '=') {}
            while (str[i] != '\n') {
                    parameter[j++] = str[i++];
            }
            parameter[j] = '\0';
            return 1;
        }
    }
}  


    
void DebugPrint(){
    //for(uint8_t i=0; i<3; i++) pc.printf("%3.2f\t",nowAngle[i]); //skipper地磁気センサ_デバック用
    //pc.printf("%3.2f\t",nowAngle[2]);
    //pc.printf("%3.2f\t",nowAngle_HMC); //HMC
    //pc.printf("\r\n");
    }