#ifndef _MPU9255_H_
#define _MPU9255_H_

#include"mbed.h"
#include"MPU9255Regs.h"

// Set initial input parameters
#define  AFS_2G  0
#define  AFS_4G  1
#define  AFS_8G  2
#define  AFS_16G 3

#define  GFS_250DPS  0
#define  GFS_500DPS  1
#define  GFS_1000DPS 2
#define  GFS_2000DPS 3

#define  MFS_14BITS  0 // 0.6 mG per LSB
#define  MFS_16BITS  1    // 0.15 mG per LSB

#define M_8Hz   0x02
#define M_100Hz 0x06


class MPU9255
{
    I2C *i2c_p;
    I2C &i2c;
    RawSerial* pc_p;
    
    void writeByte(uint8_t address, uint8_t subAddress, uint8_t data);
    char readByte(uint8_t address, uint8_t subAddress);
    void readBytes(uint8_t address, uint8_t subAddress, uint8_t count, uint8_t * dest);

public:
    MPU9255(PinName sda, PinName scl, RawSerial* serial_p);
    ~MPU9255();
    
    void init_mpu9255(uint8_t Ascale, uint8_t Cscale, uint8_t asmpleRate);
    uint8_t whoami_mpu9255();
    void reset_mpu9255();
    void selftest_mpu9255(float * destination);
    float getAres(uint8_t Ascale);
    float getGres(uint8_t Gscale);
    float getMres(uint8_t Mscale);
    void calibrate_mpu9255(float * dest1, float * dest2);
    uint8_t get_AK8963CID();
    void init_AK8963Slave(uint8_t Mscale, uint8_t Mmode, float * magCalibration);
    void readMagData_mpu9255(int16_t * destination);
    void readaccgyrodata_mpu9255(int16_t * destination);
};

#endif