#ifndef _MPU6050_DMP_6_H_
#define _MPU6050_DMP_6_H_

#include "MPU6050.h"
#include "mbed.h"
#include "I2Cdev.h"
#include "MODSERIAL.h"

#define MPU6050_INCLUDE_DMP_MOTIONAPPS20

class MPU6050DMP6 {
public:
    MPU6050DMP6(PinName intpin, MODSERIAL* serial_p);
    ~MPU6050DMP6();

  int setup();
  void loop();
  void getRollPitchYaw_Skipper(float RPY[3]);


private:
    MODSERIAL* pc_p;
    InterruptIn *checkpin_p;
    InterruptIn &checkpin;

    MPU6050 mpu;
//MPU6050 mpu(0x69); // <-- use for AD0 high


// MPU control/status vars
    bool dmpReady;  // set true if DMP init was successful
    uint8_t mpuIntStatus;   // holds actual interrupt status byte from MPU
    uint8_t devStatus;      // return status after each device operation (0 = success, !0 = error)
    uint16_t packetSize;    // expected DMP packet size (default is 42 bytes)
    uint16_t fifoCount;     // count of all bytes currently in FIFO
    uint8_t fifoBuffer[64]; // FIFO storage buffer

// orientation/motion vars
    Quaternion q,q2;           // [w, x, y, z]         quaternion container
    VectorInt16 aa;         // [x, y, z]            accel sensor measurements
    VectorInt16 aaReal;     // [x, y, z]            gravity-free accel sensor measurements
    VectorInt16 aaWorld;    // [x, y, z]            world-frame accel sensor measurements
    VectorFloat gravity;    // [x, y, z]            gravity vector
    float euler[3];         // [psi, theta, phi]    Euler angle container
    float ypr[3];           // [yaw, pitch, roll]   yaw/pitch/roll container and gravity vector

// packet structure for InvenSense teapot demo
    uint8_t teapotPacket[14];

// ================================================================
// ===               INTERRUPT DETECTION ROUTINE                ===
// ================================================================

    volatile bool mpuInterrupt;     // indicates whether MPU interrupt pin has gone high

    void dmpDataReady();
    void transformeCoordinate_Skipper(Quaternion* q1, Quaternion* q2);
    int loopstarting();
    void initializeValue();

};

#endif /* _MPU6050_DMP_6_H_ */