#ifndef _L6470_H_
#define _L6470_H_

#include"mbed.h"

//L6470 Registers
#define ABS_POS    0x01 // Current position
#define EL_POS     0x02 // Electrical position
#define MARK       0x03
#define SPEED      0x04
#define ACC        0x05
#define DEC        0x06
#define MAX_SPEED  0x07
#define MIN_SPEED  0x08
#define FS_SPD     0x15
#define KVAL_HOLD  0x09
#define KVAL_RUN   0x0A
#define KVAL_ACC   0x0B
#define KVAL_DEC   0x0C
#define INT_SPEED  0x0D
#define ST_SLP     0x0E
#define FN_SLP_ACC 0x0F
#define FN_SLP_DEC 0x10
#define K_THERM    0x11
#define ADC_OUT    0x12
#define OCD_TH     0x13
#define STALL_TH   0x14
#define STEP_MODE  0x16
#define ALARM_EN   0x17
#define CONFIG     0x18
#define STATUS     0x19

//L6470 Commands
#define NOP 0x000
#define SetParam 0x0<<5 // ( | PARAM )
#define GetParam 0x01<<5 // ( | PARAM )
#define Run_Forward 0x50
#define Run_Back 0x51
#define Step_Clock_Forward 0x58
#define Step_Clock_Back 0x59
#define Move_Forward 0x40
#define Move_Back 0x41 
#define GoTo 0x60
#define GoTo_DIR_Forward 0x68
#define GoTo_DIR_Back 0x69
//#define GoUntill
//#define ReleseSW 
#define GoHome 0x70
#define GoMark 0x78
#define ResetPos 0xD8
#define ResetDevice 0xC0
#define SoftStop 0xB0
#define HardStop 0xB8
#define SoftHiZ 0xA0
#define HardHiz 0xA8
#define GetStatus 0xD8




class L6470 
{
    SPI _spi;
    DigitalOut _cs;
    
    public:
    L6470(PinName mosi, PinName miso, PinName sclk, PinName cs):_spi(mosi, miso, sclk),_cs(cs)
    {
        _spi.format(8,2);
        _spi.frequency(4960000);
    }
    //~L6470();

    
    //L6470(PinName mosi, PinName miso, PinName sclk, PinName ssel);
    
    void init()
    {
        // L6470のspi通信の有効化
    //_spi.format(8,2);
    //_spi.frequency(4960000);
    
    //　nopを送ることで残留している命令を排除
    _cs = 1;
    _spi.write(0x00);
    _spi.write(0x00);
    _spi.write(0x00);
    _spi.write(0x00);
    _cs = 0;
        
    //リセット
    _cs = 1;
    _spi.write(0xC0);
    _cs = 0;
        
    // MAX_SPEED設定。
    _cs = 1;
    _spi.write(0x07);
    // 最大回転スピード値(10bit) 初期値は 0x41
    _spi.write(0x00);
    _spi.write(0x23);
    _cs = 0;

    // KVAL_HOLD設定。
    /// レジスタアドレス。
    _cs = 1;
    _spi.write(0x09);
    _spi.write(0xFF);
    _cs = 0;
        
    // KVAL_spiUN設定。
    /// レジスタアドレス。
    _cs = 1;
    _spi.write(0x0A);
    _spi.write(0xFF);
    _cs = 0;
        
    // KVAL_ACC設定。
    _cs = 1;
    _spi.write(0x0B);
    _spi.write(0xFF);
    _cs = 0;
        
    // KVAL_DEC設定。
    /// レジスタアドレス。
    _cs= 1;
    _spi.write(0x0C);
    _spi.write(0x40);
    _cs = 0;
        
    // OCD_TH設定。
    /// レジスタアドレス。
    _cs = 1;
    _spi.write(0x13);
    _spi.write(0x0F);
    _cs = 0;
        
    // STALL_TH設定。
    /// レジスタアドレス。
    _cs = 1;
    _spi.write(0x14);
    _spi.write(0x7F);
    _cs = 0;
};
    //void writeByte(uint8_t);
    void writeByte(uint8_t data)
{
    _cs = 1;
    _spi.write(data);
    _cs = 0;
}

    void writeBytes(uint8_t add, int bytes, uint32_t value)
{
    uint32_t data[3];
    for (int i = 0; i < bytes; i++){
        data[i] = value & 0xff;
        value = value >> 8;
    }
    if(bytes == 3){
        _cs = 1;
        _spi.write(add);
        _spi.write(data[2]);
        _spi.write(data[1]);
        _spi.write(data[0]);
        _cs = 0;
        }
    else if ( bytes == 2 ) {
        _cs = 1;
        _spi.write( add );
        _spi.write( data[1] ) ;
        _spi.write( data[0] ) ;
        _cs = 0;
    }
    else if ( bytes == 1 ) {
        _cs = 1;
        _spi.write( add );
        _spi.write( data[0] ) ;
        _cs = 0;
    }
}

    //void writeBytes(uint8_t, int, uint32_t);
    void L6470_run(uint32_t speed)
{
        uint8_t dir;
        uint32_t spd;
        uint8_t spd_h;
        uint8_t spd_m;
        uint8_t spd_l;

        // 方向検出。
        if (speed < 0)
        {
            dir = 0x50;
            spd = -1 * speed;
        }
        else
        {
            dir = 0x51;
            spd = speed;
        }

        // 送信バイトデータ生成。
        spd_h = (uint8_t)((0x000F0000 & spd) >> 16);
        spd_m = (uint8_t)((0x0000FF00 & spd) >> 8);
        spd_l = (uint8_t)(0x000000FF & spd);
        // コマンド（レジスタアドレス）送信。
        _cs = 1;
        _spi.write(dir);
        _spi.write(spd_h);
        _spi.write(spd_m);
        _spi.write(spd_l);
        _cs = 0;
}    

    //void L6470_run(uint32_t);
    
};
    
    
#endif