#ifndef MBED_SUBS_H
#define MBED_SUBS_H


#include "mbed.h"

#define SBUS_SIGNAL_OK          0x00
#define SBUS_SIGNAL_LOST        0x01
#define SBUS_SIGNAL_FAILSAFE    0x03

typedef void (*V_FUNC_V)(void);

class SBUS
{
public:
    uint16_t manualpwm[8];  //pwmの数値　1000~2000で表記 main文ではこの変数を使う
    uint8_t  failsafe_status; 
    bool flg_ch_update;

    //コンストラクタ
    SBUS();
    SBUS(PinName tx, PinName rx);
    //デストラクタ
    virtual ~SBUS();    //この場合virtualをつける必要はなさそうだが参考プログラムについてたため一応入れる

    void initialize(void);  //初期化
    void startInterrupt(void);  //シリアル割り込み開始
    //void stopInterrupt(void);
    void setLastfuncPoint(void (*func)(void));  //割り込み処理実行後に行う関数を設定　PWM出力用


private:
    RawSerial   *rawserial_p;
    RawSerial &rawserial;

    volatile    uint8_t buf_sbus[25];
    volatile    int cnt_sbus;
    uint8_t byte_in_sbus;
    uint8_t bit_in_sbus;
    uint8_t ch;
    uint8_t bit_in_channel;
    int16_t channels[18];       //元はstatic int16_t channels[18];
    V_FUNC_V lastfunc;

    void func_interrupt(void);  //シリアル割り込みで実行する関数 
    int8_t catchSerial(void);   //シリアルデータを取得
    void unpackSerialdata(void);   //シリアルデータから各チャンネルの情報を取得
    void inputPwm(void);    //manualpwm変数に値を入力
};


#endif