#ifndef PID_MBED_H
#define PID_MBED_H


#include "mbed.h"

class PID
{
public:
    double kp, ki, kd, max, min, dt; 

    //コンストラクタ
    PID();
    PID(double Pgain, double Igain, double Dgain);
    PID(double Pgain, double Igain, double Dgain, double Max, double Min);
    //デストラクタ
    ~PID();

    void initialize(void);
    void setPIDgain(double Pgain, double Igain, double Dgain);
    void setMaxMin(double Max, double Min);
    void switchMaxMin(bool Maxcheck, bool Mincheck);
    double calcPID(double nowval, double targetval, double dt);


private:
    double integral;
    double oldval[2], diff[2];
    bool maxcheck, mincheck;
};

#endif