#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"
#include "mbed.h"
#define _USE_MATH_DEFINES

#include "math.h"

#define Pi 3.14159
int RSX,RSY,LSX,LSY,BSU,BSL;
//これより下に関数外に書く要素を記入する
//spi通信用
SPI spi(p5,p6,p7);
DigitalOut cs(p8);
//オムニホイール

/*　　　正転の向き
　　　　ｌ↙　　　↖ｆ　　　　
　　　　　　　　　　　　　　
　　　　　 　→
　　　　　　ｒ　　　　　　 */
PwmOut motor_f_1(p21);
PwmOut motor_f_2(p22);
PwmOut motor_l_1(p23);
PwmOut motor_l_2(p24);
PwmOut motor_r_1(p25);
PwmOut motor_r_2(p26);

double fai=60;//φ
//個体差で出力調整
double power_f=0.8;
double power_l=0.8;
double power_r=0.8;

double M1;
double M2;
double M3;

//ジョイスティックの中心座標
double center=127;


//ジョイスティック閾値
double delta=90;
double bound_p=center+delta;
double bound_m=center-delta;


//回転の比
double roll_spd=0.5;
void motor_act()
{
    if(M1 >=0) {
        motor_f_1=M1;
        motor_f_2=0;
    } else {
        motor_f_1=0;
        motor_f_2=-M1;
    }

    if(M2 >=0) {
        motor_l_1=M2;
        motor_l_2=0;
    } else {
        motor_l_1=0;
        motor_l_2=-M2;
    }

    if(M3 >=0) {
        motor_r_1=M3;
        motor_r_2=0;
    } else {
        motor_r_1=0;
        motor_r_2=-M3;
    }



}
double sita;
double sita_2;



void UserLoopSetting()
{
    spi.format(8,3);
    spi.frequency(1000000);
    motor_f_1.period_us(50);
    motor_f_2.period_us(50);
    motor_l_1.period_us(50);
    motor_l_2.period_us(50);
    motor_r_1.period_us(50);
    motor_r_2.period_us(50);

}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0) { //有線Ps3USB.cpp
        RSX = ((ps3report*)data)->RightStickX;
        RSY = ((ps3report*)data)->RightStickY;
        LSX = ((ps3report*)data)->LeftStickX;
        LSY = ((ps3report*)data)->LeftStickY;
        BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)data)->ButtonState;
    } else {//無線TestShell.cpp
        RSX = ((ps3report*)(data + 1))->RightStickX;
        RSY = ((ps3report*)(data + 1))->RightStickY;
        LSX = ((ps3report*)(data + 1))->LeftStickX;
        LSY = ((ps3report*)(data + 1))->LeftStickY;
        BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
        BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
        //ボタンの処理
        ButtonState =  ((ps3report*)(data + 1))->ButtonState;
    }
    //ここより下にプログラムを書く
    //spi通信用プログラム

    int L_up,L_down,L_open,L_close,R_up,R_down,R_open,R_close;
    int send = 0;



    if((ButtonState >> BUTTONUP)&1 == 1) {//対応するボタンを書く(今回上ボタン
        L_up = 1;
    } else {
        L_up = 0;
    }

    if((ButtonState >> BUTTONDOWN)&1 == 1) {//対応するボタンを書く(今回下ボタン
        L_down = 2;
    } else {
        L_down = 0;
    }

    if((ButtonState >> BUTTONL1)&1 == 1) {//対応するボタンを書く(今回L1ボタン
        L_open = 4;
    } else {
        L_open = 0;
    }

    if((ButtonState >> BUTTONL2)&1 == 1) {//対応するボタンを書く(今回L2ボタン
        L_close = 8;
    } else {
        L_close = 0;
    }

    if((ButtonState >> BUTTONTRIANGEL)&1 == 1) {//対応するボタンを書く(今回△ボタン
        R_up = 16;
    } else {
        R_up = 0;
    }

    if((ButtonState >> BUTTONCROSS)&1 == 1) {//対応するボタンを書く(今回×ボタン
        R_down = 32;
    } else {
        R_down = 0;
    }

    if((ButtonState >> BUTTONR1)&1 == 1) {//対応するボタンを書く(今回R1ボタン
        R_open = 64;
    } else {
        R_open = 0;
    }

    if((ButtonState >> BUTTONR2)&1 == 1) {//対応するボタンを書く(今回R2ボタン
        R_close = 128;
    } else {
        R_close = 0;
    }



    send = L_up+L_down+L_open+L_close+R_up+R_down+R_open+R_close;

    cs = 0;
    spi. write(send);
    cs = 1;
    // printf("%d\r\n",send);



//オムニホイールのプログラム
    if(LSX>=bound_m && LSX<=bound_p && LSY>=bound_m && LSY<=bound_p) {
        M1=0;
        M2=0;
        M3=0;
        if(RSX>=bound_p && RSX<=255) {
            M1=power_f*roll_spd;
            M2=power_l*roll_spd;
            M3=power_r*roll_spd;
        } else if(RSX>=0 && RSX<=bound_m) {
            M1=-1.0*power_f*roll_spd;
            M2=-1.0*power_l*roll_spd;
            M3=-1.0*power_r*roll_spd;
        }

        motor_act();

        sita=0;
    } else {
        if(LSX>=center && LSX<=255 && LSY>=center && LSY<=255) { //第四象限
            sita = -1.0*(atan2((double)LSY-center,(double)LSX-center))*180/Pi;
            sita_2=90-sita;
            M1=sin((sita_2-(fai+0))*Pi/180)*power_f;
            M2=sin((sita_2-(fai+240))*Pi/180)*power_l;
            M3=sin((sita_2-(fai+120))*Pi/180)*power_r;
            motor_act();
        } else if(LSX>=0 && LSX<=center && LSY>=center && LSY<=255) { //第三象限
            sita = -1.0*(atan2((double)LSY-center,(double)LSX-center))*180/Pi;
            sita_2=90-sita;
            M1=sin((sita_2-(fai+0))*Pi/180)*power_f;
            M2=sin((sita_2-(fai+240))*Pi/180)*power_l;
            M3=sin((sita_2-(fai+120))*Pi/180)*power_r;
            motor_act();
        } else if(LSX>=0 && LSX<=center && LSY>=0 && LSY<=center) { //第二象限
            sita = -1.0*(atan2((double)LSY-center,(double)LSX-center))*180/Pi;
            sita_2=90-sita;
            M1=sin((sita_2-(fai+0))*Pi/180)*power_f;
            M2=sin((sita_2-(fai+240))*Pi/180)*power_l;
            M3=sin((sita_2-(fai+120))*Pi/180)*power_r;
            motor_act();
        } else if(LSX>=center && LSX<=255 && LSY>=0 && LSY<=center) { //第一象限
            sita = -1.0*(atan2((double)LSY-center,(double)LSX-center))*180/Pi;
            sita_2=90-sita;
            M1=sin((sita_2-(fai+0))*Pi/180)*power_f;
            M2=sin((sita_2-(fai+240))*Pi/180)*power_l;
            M3=sin((sita_2-(fai+120))*Pi/180)*power_r;
            motor_act();
        }
//真っすぐだけのプログラム(いらない）

        /*else if(LSX==255) {
                 sita = 0;
                 sita_2=90-sita;
                 M1=sin((sita_2-fai)*Pi/180)*power_f;
                 M2=sin((sita_2-fai+240)*Pi/180)*power_l;
                 M3=sin((sita_2-fai+120)*Pi/180)*power_r;
                 motor_act();

             } else if(LSY==255) {
                 sita = -90;
                 sita_2=90-sita;
                 M1=sin((sita_2-fai)*Pi/180)*power_f;
                 M2=sin((sita_2-fai+240)*Pi/180)*power_l;
                 M3=sin((sita_2-fai+120)*Pi/180)*power_r;
                 motor_act();

             } else if(LSX==0) {
                 sita = 180;
                 sita_2=90-sita;
                 M1=sin((sita_2-fai)*Pi/180)*power_f;
                 M2=sin((sita_2-fai+240)*Pi/180)*power_l;
                 M3=sin((sita_2-fai+120)*Pi/180)*power_r;
                 motor_act();

             } else if(LSY==0) {
                 sita = 90;
                 sita_2=90-sita;
                 M1=sin((sita_2-fai)*Pi/180)*power_f;
                 M2=sin((sita_2-fai+240)*Pi/180)*power_l;
                 M3=sin((sita_2-fai+120)*Pi/180)*power_r;
                 motor_act();
             } */

    }




    printf("motor_f_1:%.4f\t\motor_l_1:%.4f\t\motor_r_1:%.4f\t\sita:%f\r\n",M1,M2,M3,sita);



}