#pragma once

#include "mbed.h"
#include "CubeObj.h"
#include<stdlib.h>

#define ParticleNUM 50

class Fireworks{
    public:
    bool isWork;
    int sx, sy, bz;
    float z;
    COL cols[2];
    
    CubeObj ff[ParticleNUM];
    
    Fireworks(){
        isWork = false;
        sx = 0;
        sy = 0;
        z = 0;
    }
    void SetColor(COL c1, COL c2){
        cols[0] = c1;
        cols[1] = c2;
    }
    void explSet(int x, int y, int z, float s = 0.8){
        for(int i = 0; i < ParticleNUM; i++){
            if(i % 2 == 0)ff[i].set(s, y, z, cols[0]);
            else ff[i].set(x, y, z, cols[1]);
            ff[i].set(
            (float)(rand()%360)*(PI/180), 
            (float)(rand()%360)*(PI/180), 
            (float)(rand()%((int)350))/1000);
        }
    }
    void explosion(){
        for(int i = 0; i < ParticleNUM; i++){
            ff[i].go();
            ff[i].friction(1.05);
            ff[i].gravity(0.0005);
        }    
    }
    void put(int px, int py, int burnz){
        if(!isWork){
            sx = px;
            sy = py;
            bz = burnz;
            z = 0;
            isWork = true;
            explSet(sx, sy, bz);
        }
    }
    void Update(){
        if(z > bz){
            explosion();
            z++;
            if(z >= bz*50)isWork = false;
        }
        else{
            if(z <= bz)PutPixel(sx, sy, z, 7); 
            z += 0.1f;
        }
    }
};