#include "mbed.h"

AnalogIn haru(dp13);
AnalogIn natsu(dp11);
AnalogIn aki(dp10);
AnalogIn huyu(dp9);

BusOut Out(dp26, dp28);

DigitalOut LED(dp4);
DigitalIn In(dp16);

DigitalOut l(dp2);

bool i = false;
void Blinky(){
    if(i){
        i = false;
        l = 1;
    }
    else{
        i = true;
        l = 0;
    }
}
int RoteTime = 0;
int RoteCount = 0;
int RoteCycle = 0;
bool RoteType = false;      //[f : 4分ローテ] [t : 10秒ローテ]
uint16_t AutoSeason = 0;

void CountFunc(){
    if(RoteType){
        if(RoteTime >= 6){
            RoteCount++;
            RoteTime = 0;
            AutoSeason = RoteCount;
        }
        if(RoteCount >= 4){
            RoteCount = 0;
            RoteTime = 0;
            AutoSeason = 0;
            RoteType = false;
        }
    }else{
        if(RoteTime >= 4){
            RoteTime = 0;
            AutoSeason = RoteCount;
            RoteCount++;
        }
        if(RoteCount >= 5){
            RoteCount = 0;
            RoteTime = 0;
            AutoSeason = 0;
            RoteType = true;
        }
    }
    RoteTime++;
}

Ticker pi;

Ticker Counter;
/*
int main() {
    int n = 0;
    pi.attach(&Blinky, 0.5);
    while (1){
        if(In){
            LED = 1;
            uint8_t out = 0;
            if(haru > 0.511){
                out = 0;
            }
            else if(natsu > 0.440){
                out = 1;
            }
            else if(aki > 0.388){
                out = 2;
            }
            else if(huyu > 0.388){
                out = 3;
            }
            Out = out;
        }
        else{
            LED = 0;
            n++;
            if(n >= 40)n = 0;
            Out = n%10;
        }
    }
}
*/

int main() {
    
    for(int i = 0; i < 50; i++){
        l = 0;
        wait(0.2);
        l = 1;
        wait(0.2);
    }
    
    pi.attach(&Blinky, 0.2);
    Counter.attach(&CountFunc, 10);
    
    while (1){
        LED = 1;
        if(haru < 0.3){
            AutoSeason = 0b00;
        }
        if(natsu < 0.4){
            AutoSeason = 0b01;
        }
        else if(aki < 0.3){
            AutoSeason = 0b10;
        }
        
        else if(huyu < 0.226784){
            AutoSeason = 3;
        }
        Out = ~AutoSeason;
        wait(2);
    }
}
