#include "mbed.h"
 
Serial bluetooth(D10, D2);
PwmOut servo(PB_10);
DigitalOut led1(LED1);
 
Ticker timer1;
int    counterTime;

void timer1Interrupt(void);
void initTimer(void);
void initIo(void); 
void initPwm(void);
void initProgram(void);
void initBlueTooth(void);
 
//Variable(s) for internal control
float   angle = 0;
float   servoDuty = 0.079;//0.079 +(0.084/180)*angle, -90<angle<90
char    pcInput = 0;
 
int main (void)
{    
    initProgram();
    
    while(1)
    {   
    
    }//while(1)      
}//int main (void)
 
void timer1Interrupt(void)
{
   pcInput = bluetooth.getc();
   
   switch( pcInput )
   {
        case 'a':
            bluetooth.printf("a\n");
            angle = 30;           
            servoDuty = 0.079 +(0.084/180)*angle;
            break;
        case 'b':
            bluetooth.printf("b\n");
            angle = 60;           
            servoDuty = 0.079 +(0.084/180)*angle;
            break;
        case 'c':
            bluetooth.printf("c\n");
            angle = 90;           
            servoDuty = 0.079 +(0.084/180)*angle;
            break;
        default:
            angle = 0;           
            servoDuty = 0.079 +(0.084/180)*angle;
            break;
    }//switch( pcInput )
   
   
   ////////馬達保護///////
    if(servoDuty > 0.121f)servoDuty = 0.121;        //若超過90度則停在90
    else if(servoDuty < 0.037f)servoDuty = 0.037;   //若低於0度則停在0度
    
    servo.write(servoDuty);
}//timerInterrupt(void)
 
void initProgram(void)
{
    initTimer();
    initIo();
    initPwm();
    initBlueTooth();
}//initProgram(void)
 
void initTimer(void)
{
    timer1.attach_us(&timer1Interrupt, 10000.0);//10ms interrupt period (100Hz)
}//initTimer(void)
       
void initIo(void)
{
    counterTime = 0;
    led1 = 0;
}//initIo(void)         
   
void initPwm(void)
{
    servo.period_ms(20);
}//initPwm(void)

void initBlueTooth(void)
{
    bluetooth.baud(115200);
}//initBlueTooth(void)
 