/**
 * @file   : ultrasonic.h (1.0)
 * @brief  : measure distance from something
 * @author : Shinnosuke KOIKE
 * @date   : 2015/08/04
 */

#ifndef ULTRASONIC_H
#define ULTRASONIC_H

#include "mbed.h"
#include "hcsr04.h"

class Ultrasonic {
public:
    Ultrasonic(PinName trig, PinName echo);
    ~Ultrasonic();
    int measureDist(void);

private:
    HCSR04* hcsr04;
};

// initialize
Ultrasonic::Ultrasonic(PinName trig, PinName echo) {
    hcsr04 = new HCSR04(trig, echo);
}

Ultrasonic::~Ultrasonic() {
    delete hcsr04;
}

// return distance from something
int Ultrasonic::measureDist(void) {
    wait(0.1);
    int dist = hcsr04->distance();
    return dist;
}

#endif

/**
 * example program

#include "mbed.h"
#include "ultrasonic.h"

int main(void) {
    Ultrasonic ultrasonic(D12, D13);
    while (1) {
        pc.printf("%d\r\n", ultrasonic.measureDist());
    }
}
 */
