/**
 * @file   : line.h (1.0)
 * @brief  : find white line
 * @author : Shinnosuke KOIKE
 * @date   : 2015/08/07
 */

#ifndef LINE_H
#define LINE_H

#include "mbed.h"

class Line {
public:
    Line(PinName right, PinName back, PinName left);
    char findOnLine(void);

private:
    BusIn lineData;
};

// initialize
Line::Line(PinName right, PinName back, PinName left):
    lineData(right, back, left) {
}

// return data which if the robot get on white line
char Line::findOnLine(void) {
    char data = lineData;
    return data;
}

#endif

/**
 * example program

#include "mbed.h"
#include "line.h"

int main(void) {
    Line line(D0, D1, D2);
    while (1) {
        char data = line.findOnLine();
        pc.printf("%d\r\n", data);  // for example, display "1 0 0"
    }
}
 */
